/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;
import java.util.Locale;

public class NodeNumber
extends NodeItem {
    public NodeNumber(String value) {
        super(NodeType.NUMBER, value);
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        Tools.ensureSyntax(Tools.isNumericString(this.getValue()), SyntaxError.STRING_IS_NOT_A_NUMBER, this);
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public boolean canCastTo(DataType type, Locale locale) {
        if (!type.equals(DataType.BOOL)) {
            return super.canCastTo(type, locale);
        }
        return true;
    }

    @Override
    public DataType getDataType() {
        return DataType.NUMERIC;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    @Override
    public String getConstStringValue() {
        return this.getValue();
    }
}

