/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wittype;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitem.internal.wittype.WorkItemTypeImpl;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemTypeCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WorkItemTypeCollectionImpl
implements WorkItemTypeCollection {
    private final Set<WorkItemType> workItemTypes = new HashSet<WorkItemType>();
    private final Map<Integer, WorkItemType> idToWorkItemTypeMap = new HashMap<Integer, WorkItemType>();
    private final Map<String, WorkItemType> nameToWorkItemTypeMap = new HashMap<String, WorkItemType>();

    public WorkItemTypeCollectionImpl(ProjectImpl project, WITContext witContext) {
        WorkItemTypeMetadata[] workItemTypesMetadata = witContext.getMetadata().getWorkItemTypeTable().getWorkItemTypes(project.getID());
        for (int i = 0; i < workItemTypesMetadata.length; ++i) {
            WorkItemTypeImpl workItemType = new WorkItemTypeImpl(workItemTypesMetadata[i], project, witContext);
            if (workItemType.getID() > 0) {
                this.workItemTypes.add(workItemType);
            }
            this.nameToWorkItemTypeMap.put(workItemType.getName().toLowerCase(), workItemType);
            this.idToWorkItemTypeMap.put(workItemType.getID(), workItemType);
        }
    }

    @Override
    public WorkItemType get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return this.nameToWorkItemTypeMap.get(name.toLowerCase());
    }

    @Override
    public WorkItemType get(int id) {
        return this.idToWorkItemTypeMap.get(id);
    }

    @Override
    public Iterator<WorkItemType> iterator() {
        ArrayList<WorkItemType> types = new ArrayList<WorkItemType>(this.workItemTypes);
        Collections.sort(types);
        return Collections.unmodifiableCollection(types).iterator();
    }

    @Override
    public int size() {
        return this.workItemTypes.size();
    }

    @Override
    public WorkItemType[] getTypes() {
        Object[] types = this.workItemTypes.toArray(new WorkItemType[0]);
        Arrays.sort(types);
        return types;
    }
}

