/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.db;

import com.microsoft.tfs.core.internal.db.DBConnection;
import com.microsoft.tfs.core.internal.db.DBSpecificOperations;
import com.microsoft.tfs.core.internal.db.DBStatement;
import java.util.Locale;

public class HSQLOperations
implements DBSpecificOperations {
    private final DBConnection connection;

    public HSQLOperations(DBConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean tableExists(String tableName) {
        DBStatement stmt = this.connection.createStatement("select count(*) from INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_NAME = ?");
        return stmt.executeNumericQuery(new Object[]{tableName.toUpperCase(Locale.US)}) > 0L;
    }

    @Override
    public boolean columnExists(String tableName, String columnName) {
        DBStatement stmt = this.connection.createStatement("select count(*) from INFORMATION_SCHEMA.SYSTEM_COLUMNS where TABLE_NAME = ? and COLUMN_NAME = ?");
        return stmt.executeNumericQuery(new Object[]{tableName.toUpperCase(Locale.US), columnName.toUpperCase(Locale.US)}) > 0L;
    }
}

