/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.pendingcheckin;

import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.pendingcheckin.AffectedTeamProjects;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinPendingChanges;
import com.microsoft.tfs.core.pendingcheckin.events.AffectedTeamProjectsChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.AffectedTeamProjectsChangedListener;
import com.microsoft.tfs.core.pendingcheckin.events.CheckedPendingChangesChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.CheckedPendingChangesChangedListener;
import com.microsoft.tfs.core.pendingcheckin.events.CommentChangedEvent;
import com.microsoft.tfs.core.pendingcheckin.events.CommentChangedListener;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;

public class StandardPendingCheckinPendingChanges
implements PendingCheckinPendingChanges {
    private final SingleListenerFacade checkedPendingChangesChangedEventListeners = new SingleListenerFacade(CheckedPendingChangesChangedListener.class);
    private final SingleListenerFacade affectedTeamProjectsChangedEventListeners = new SingleListenerFacade(AffectedTeamProjectsChangedListener.class);
    private final SingleListenerFacade commentChangedEventListeners = new SingleListenerFacade(CommentChangedListener.class);
    private final AffectedTeamProjects affectedTeamProjects;
    private PendingChange[] allChanges;
    private PendingChange[] checkedChanges;
    private String comment;
    private final Workspace workspace;

    public StandardPendingCheckinPendingChanges(Workspace workspace, PendingChange[] allChanges, PendingChange[] checkedChanges, AffectedTeamProjects affectedTeamProjects, String comment) {
        Check.notNull(workspace, "workspace");
        Check.notNull(affectedTeamProjects, "affectedTeamProjects");
        Check.notNull(allChanges, "allChanges");
        Check.notNull(checkedChanges, "checkedChanges");
        this.workspace = workspace;
        this.affectedTeamProjects = affectedTeamProjects;
        this.allChanges = allChanges;
        this.checkedChanges = checkedChanges;
        this.comment = comment;
    }

    @Override
    public void addAffectedTeamProjectsChangedListener(AffectedTeamProjectsChangedListener listener) {
        this.affectedTeamProjectsChangedEventListeners.addListener(listener);
    }

    @Override
    public void removeAffectedTeamProjectsChangedListener(AffectedTeamProjectsChangedListener listener) {
        this.affectedTeamProjectsChangedEventListeners.removeListener(listener);
    }

    @Override
    public void addCheckedPendingChangesChangedListener(CheckedPendingChangesChangedListener listener) {
        this.checkedPendingChangesChangedEventListeners.addListener(listener);
    }

    @Override
    public void removeCheckedPendingChangesChangedListener(CheckedPendingChangesChangedListener listener) {
        this.checkedPendingChangesChangedEventListeners.removeListener(listener);
    }

    @Override
    public void addCommentChangedListener(CommentChangedListener listener) {
        this.commentChangedEventListeners.addListener(listener);
    }

    @Override
    public void removeCommentChangedListener(CommentChangedListener listener) {
        this.commentChangedEventListeners.removeListener(listener);
    }

    @Override
    public synchronized String[] getAffectedTeamProjectPaths() {
        return this.affectedTeamProjects.getTeamProjectPaths();
    }

    @Override
    public synchronized PendingChange[] getAllPendingChanges() {
        return this.allChanges;
    }

    @Override
    public synchronized void setAllPendingChanges(PendingChange[] changes) {
        Check.notNull(changes, "changes");
        this.allChanges = changes;
    }

    @Override
    public synchronized PendingChange[] getCheckedPendingChanges() {
        return this.checkedChanges;
    }

    @Override
    public synchronized void setCheckedPendingChanges(PendingChange[] changes) {
        Check.notNull(changes, "changes");
        this.checkedChanges = changes;
        ((CheckedPendingChangesChangedListener)this.checkedPendingChangesChangedEventListeners.getListener()).onCheckedPendingChangesChanged(new CheckedPendingChangesChangedEvent(EventSource.newFromHere()));
        if (this.affectedTeamProjects.set(changes)) {
            String[] teamProjectServerPaths = this.affectedTeamProjects.getTeamProjectPaths();
            ((AffectedTeamProjectsChangedListener)this.affectedTeamProjectsChangedEventListeners.getListener()).onAffectedTeamProjectsChanged(new AffectedTeamProjectsChangedEvent(EventSource.newFromHere(), teamProjectServerPaths));
        }
    }

    @Override
    public synchronized String getComment() {
        return this.comment;
    }

    @Override
    public synchronized void setComment(String comment) {
        this.comment = comment;
        ((CommentChangedListener)this.commentChangedEventListeners.getListener()).onCommentChanged(new CommentChangedEvent(EventSource.newFromHere(), comment));
    }

    @Override
    public synchronized Workspace getWorkspace() {
        return this.workspace;
    }
}

