/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.FileSystemTime;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.text.MessageFormat;

public class FileSystemAttributes {
    private final boolean exists;
    private final FileSystemTime modificationTime;
    private final long size;
    private boolean readOnly;
    private boolean ownerOnly;
    private boolean publicWritable;
    private boolean hidden;
    private boolean system;
    private final boolean directory;
    private boolean archive;
    private boolean notContentIndexed;
    private boolean executable;
    private final boolean symbolicLink;

    public FileSystemAttributes() {
        this(false, new FileSystemTime(0L), -1L, false, false, false, false, false, false, false, false, false, false);
    }

    public FileSystemAttributes(boolean exists, FileSystemTime modificationTime, long size, boolean readOnly, boolean ownerOnly, boolean publicWritable, boolean hidden, boolean system, boolean directory, boolean archive, boolean notContentIndexed, boolean executable, boolean symbolicLink) {
        if (exists) {
            Check.notNull(modificationTime, "modificationTime");
        }
        this.exists = exists;
        this.modificationTime = modificationTime;
        this.size = size;
        this.readOnly = readOnly;
        this.ownerOnly = ownerOnly;
        this.publicWritable = publicWritable;
        this.hidden = hidden;
        this.system = system;
        this.directory = directory;
        this.archive = archive;
        this.notContentIndexed = notContentIndexed;
        this.executable = executable;
        this.symbolicLink = symbolicLink;
    }

    public boolean exists() {
        return this.exists;
    }

    public FileSystemTime getModificationTime() {
        return this.modificationTime;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isOwnerOnly() {
        return this.ownerOnly;
    }

    public void setOwnerOnly(boolean ownerOnly) {
        this.ownerOnly = ownerOnly;
    }

    public boolean isPublicWritable() {
        return this.publicWritable;
    }

    public void setPublicWritable(boolean publicWritable) {
        this.publicWritable = publicWritable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public boolean isDirectory() {
        return this.directory && !this.isSymbolicLink();
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public boolean isNotContentIndexed() {
        return this.notContentIndexed;
    }

    public void setNotContentIndexed(boolean notContentIndexed) {
        this.notContentIndexed = notContentIndexed;
    }

    public boolean isExecutable() {
        if (!Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            return false;
        }
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public boolean isSymbolicLink() {
        if (!Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            return false;
        }
        return this.symbolicLink;
    }

    public String toString() {
        return MessageFormat.format("FileSystemAttributes [exists={0}, modificationTime={1}, size={2}, readOnly={3}, ownerOnly={4}, publicWritable={5}, hidden={6}, system={7}, directory={8}, archive={9}, executable={10}, symbolicLink={11}]", this.exists, this.modificationTime, this.size, this.readOnly, this.ownerOnly, this.publicWritable, this.hidden, this.system, this.directory, this.archive, this.executable, this.symbolicLink);
    }
}

