/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOUtils {
    private static final Log log = LogFactory.getLog(IOUtils.class);

    public static void closeSafely(InputStream stream) {
        block2: {
            Check.notNull(stream, "stream");
            try {
                stream.close();
            }
            catch (IOException e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"error closing InputStream", (Throwable)e);
            }
        }
    }

    public static void closeSafely(OutputStream stream) {
        block2: {
            Check.notNull(stream, "stream");
            try {
                stream.close();
            }
            catch (IOException e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"error closing OutputStream", (Throwable)e);
            }
        }
    }

    public static void closeSafely(Reader reader) {
        block2: {
            Check.notNull(reader, "reader");
            try {
                reader.close();
            }
            catch (IOException e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"error closing Reader", (Throwable)e);
            }
        }
    }

    public static void closeSafely(Writer writer) {
        block2: {
            Check.notNull(writer, "writer");
            try {
                writer.close();
            }
            catch (IOException e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"error closing Writer", (Throwable)e);
            }
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, baos);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Check.notNull(inputStream, "inputStream");
        Check.notNull(outputStream, "outputStream");
        long count = 0L;
        try {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
                count += (long)length;
            }
        }
        finally {
            IOUtils.closeSafely(inputStream);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File inputFile, File outputFile) {
        Check.notNull(inputFile, "inputFile");
        Check.notNull(outputFile, "outputFile");
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            try {
                FileInputStream inputStream = new FileInputStream(inputFile);
                IOUtils.copy(inputStream, outputStream);
            }
            finally {
                IOUtils.closeSafely(outputStream);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)MessageFormat.format("Error copying {0} to {1}: ", inputFile.getAbsolutePath(), outputFile.getAbsolutePath()), (Throwable)e);
            return false;
        }
    }

    public static String toString(InputStream inputStream, String charsetName) throws IOException {
        Check.notNull(inputStream, "inputStream");
        Check.notNullOrEmpty(charsetName, "charsetName");
        return new String(IOUtils.toByteArray(inputStream), charsetName);
    }
}

