/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.parser.EQueryTimeSuffix;
import org.conqat.lib.commons.string.StringUtils;

public class StaticOperand {
    private final String value;

    public StaticOperand(String value) {
        this.value = value;
    }

    public String getAsString() {
        return this.value;
    }

    public Object convertTo(EKeyedObjectType type) throws QueryCompilationException {
        switch (type) {
            case NUMBER: {
                return StaticOperand.parseNumber(this.value);
            }
            case DATE: {
                return StaticOperand.normalizeDate(this.value);
            }
            case STRING: 
            case STRING_LIST: {
                return this.value;
            }
        }
        throw new QueryCompilationException("Unknown type: " + String.valueOf((Object)type), type.name());
    }

    protected static long parseNumber(String value) throws QueryCompilationException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            try {
                return StaticOperand.parseDurationLiteral(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new QueryCompilationException("Could not convert " + value + " to a number!", value);
            }
        }
    }

    public static long parseDurationLiteral(String text) {
        long factor = EQueryTimeSuffix.DAYS.getFactor();
        for (EQueryTimeSuffix suffix : EQueryTimeSuffix.values()) {
            if (!text.endsWith(suffix.getSuffix())) continue;
            text = StringUtils.stripSuffix((String)text, (String)suffix.getSuffix());
            factor = suffix.getFactor();
            break;
        }
        return factor * Long.parseLong(text);
    }

    protected static String normalizeDate(String value) throws QueryCompilationException {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        try {
            LocalDate date = LocalDate.parse(value);
            return DateTimeFormatter.ISO_LOCAL_DATE.format(date);
        }
        catch (DateTimeParseException e) {
            throw new QueryCompilationException("Could not parse " + value + " to a date: " + e.getMessage(), value);
        }
    }

    public String toString() {
        return this.value;
    }
}

