/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitInfoBasedBranchingLayerBase;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.Nullable;

public interface IBranchCommitInfo {
    public byte[] getCommitName();

    public byte[] getParentCommitName();

    default public Pair<String, Long> getBranchNameAndTimestamp() {
        return BranchCommitInfoBasedBranchingLayerBase.parseCommitName(this.getCommitName());
    }

    default public String getDisplayBranchNameAndTimestamp() {
        Pair<String, Long> branchAndTimeStamp = BranchCommitInfoBasedBranchingLayerBase.parseCommitName(this.getCommitName());
        return (String)branchAndTimeStamp.getFirst() + ":" + String.valueOf(branchAndTimeStamp.getSecond());
    }

    default public String getBranchName() {
        return (String)this.getBranchNameAndTimestamp().getFirst();
    }

    default public long getTimestamp() {
        return (Long)this.getBranchNameAndTimestamp().getSecond();
    }

    default public Pair<String, Long> getParentCommitBranchAndTimestamp() {
        byte[] parentCommitName = this.getParentCommitName();
        if (parentCommitName == null) {
            return null;
        }
        return BranchCommitInfoBasedBranchingLayerBase.parseCommitName(parentCommitName);
    }

    public ECommitStatus getStatus();

    public byte[] getCommitNameForDataKeys();

    public byte[] @Nullable [] getAllDeltaPredecessorCommitNamesForDataKeys();

    public byte[] getDeltaPredecessorCommitName();

    public int getDepth();

    public IBranchCommitInfo cloneWithNewStatus(ECommitStatus var1);

    public byte[] serializeToBytes() throws StorageException;

    default public CommitDescriptor toCommitDescriptor() {
        return new CommitDescriptor(this.getBranchName(), this.getTimestamp());
    }
}

