/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.RunnableWithException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class InterruptAwareStore
implements IStore {
    private final IStore delegate;

    public InterruptAwareStore(IStore store) {
        CCSMAssert.isNotNull((Object)store, () -> String.format("Expected \"%s\" to be not null", "store"));
        this.delegate = store;
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        return this.delegate.get(key);
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        return this.delegate.get(keys);
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.put(key, value);
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.put(keysValues);
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.remove(key);
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.remove(keys);
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.removeByPrefix(prefix);
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scan(beginKey, endKey, callback);
    }

    @Override
    public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scan(prefix, callback);
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, IKeyValueCallback callback) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scan(prefixes, callback);
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scanKeys(beginKey, endKey, callback);
    }

    @Override
    public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scanKeys(prefix, callback);
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, IKeyValueCallback callback) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scanKeys(prefixes, callback);
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scan(prefixes, callbacks);
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.scanKeys(prefixes, callbacks);
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.delegate.obtainLock(suffix);
    }

    @Override
    public void performWithLock(RunnableWithException<StorageException> lockAction) throws StorageException {
        InterruptAwareStore.checkForInterrupt();
        this.delegate.performWithLock(lockAction);
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        return this.delegate.getCapability(capability);
    }

    private static void checkForInterrupt() throws StorageException {
        if (Thread.interrupted()) {
            throw new StorageException(new InterruptedException("Thread was interrupted"));
        }
    }
}

