/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;

public abstract class StringAbbreviationDeserializerBase<T> {
    private final StorageStringAbbreviator stringAbbreviator;
    private Map<Integer, String> unAbbreviationMap = null;
    private final Set<Integer> idsToLookup = new HashSet<Integer>();

    protected StringAbbreviationDeserializerBase(StorageStringAbbreviator stringAbbreviator) {
        this.stringAbbreviator = stringAbbreviator;
    }

    public void extractStringIdsToLoadIntoUnAbbreviationMap(byte[] data, int offset) {
        if (this.unAbbreviationMap != null) {
            throw new UnsupportedOperationException("Must extract all string ids before calling deserialize() for the first time.");
        }
        this.idsToLookup.addAll(this.extractUnAbbreviationIds(data, offset));
    }

    protected abstract Collection<Integer> extractUnAbbreviationIds(byte[] var1, int var2);

    public T deserialize(byte[] data, int offset) throws StorageException {
        if (this.unAbbreviationMap == null) {
            this.unAbbreviationMap = this.stringAbbreviator.buildUnabbreviationMap(this.idsToLookup);
        }
        return this.deserializeFromByteArrayInternal(data, offset, this.unAbbreviationMap);
    }

    protected abstract T deserializeFromByteArrayInternal(byte[] var1, int var2, Map<Integer, String> var3);
}

