/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.filter.request;

import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.annotation.Priority;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Provider
@Priority(value=4999)
public class RequiredParameterFilter
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        RequiredParameterFilter.checkIfParametersRequiredAndPresent(requestContext, this.resourceInfo.getResourceMethod());
        RequiredParameterFilter.checkIfFieldsRequiredAndPresent(requestContext, Arrays.asList(this.resourceInfo.getResourceClass().getFields()));
    }

    private static void checkIfFieldsRequiredAndPresent(ContainerRequestContext requestContext, List<Field> inputs) {
        inputs.forEach(parameter -> RequiredParameterFilter.checkIfFieldRequiredAndPresent(requestContext, parameter));
    }

    private static void checkIfParametersRequiredAndPresent(ContainerRequestContext requestContext, Method method) {
        List allParameterAnnotations = ServiceAnnotationUtils.getAllParameterAnnotations((Method)method);
        for (int i = 0; i < method.getParameterCount(); ++i) {
            boolean isBeanParam;
            java.lang.reflect.Parameter parameter = method.getParameters()[i];
            List parameterAnnotations = (List)allParameterAnnotations.get(i);
            boolean bl = isBeanParam = RequiredParameterFilter.getAnnotation(parameterAnnotations, BeanParam.class) != null;
            if (isBeanParam) {
                Class<?> type = parameter.getType();
                RequiredParameterFilter.checkIfFieldsRequiredAndPresent(requestContext, ReflectionUtils.getAllFields(type));
            }
            RequiredParameterFilter.checkIfRequiredAndPresent(requestContext, parameterAnnotations);
        }
    }

    private static void checkIfFieldRequiredAndPresent(ContainerRequestContext requestContext, Field annotatedElement) {
        BeanParam beanParam = annotatedElement.getAnnotation(BeanParam.class);
        if (beanParam != null) {
            Class<?> type = annotatedElement.getType();
            RequiredParameterFilter.checkIfFieldsRequiredAndPresent(requestContext, ReflectionUtils.getAllFields(type));
            return;
        }
        RequiredParameterFilter.checkIfRequiredAndPresent(requestContext, Arrays.asList(annotatedElement.getAnnotations()));
    }

    private static <T extends Annotation> T getAnnotation(List<Annotation> parameterAnnotations, Class<T> annotationClass) {
        Optional<Annotation> annotation = parameterAnnotations.stream().filter((? super T a) -> a.annotationType().equals(annotationClass)).findFirst().map(annotationClass::cast);
        return (T)((Annotation)annotation.orElse(null));
    }

    private static void checkIfRequiredAndPresent(ContainerRequestContext requestContext, List<Annotation> parameterAnnotations) {
        String queryAnnotationName;
        QueryParam queryAnnotation = RequiredParameterFilter.getAnnotation(parameterAnnotations, QueryParam.class);
        Parameter parameterDoc = RequiredParameterFilter.getAnnotation(parameterAnnotations, Parameter.class);
        if (queryAnnotation == null || parameterDoc == null || !parameterDoc.required()) {
            RequestBody requestBody = RequiredParameterFilter.getAnnotation(parameterAnnotations, RequestBody.class);
            if (requestBody != null && requestBody.required() && !requestContext.hasEntity()) {
                throw new BadRequestException("Required request body is missing!");
            }
            return;
        }
        MultivaluedMap queryParameters = requestContext.getUriInfo().getQueryParameters();
        if (!queryParameters.containsKey((Object)(queryAnnotationName = queryAnnotation.value()))) {
            throw new BadRequestException("Required query parameter " + queryAnnotationName + " is missing!");
        }
        if (parameterDoc.allowEmptyValue()) {
            return;
        }
        for (String parameterValue : (List)queryParameters.get((Object)queryAnnotationName)) {
            if (!StringUtils.isEmpty((String)parameterValue)) continue;
            throw new BadRequestException("Required query parameter " + queryAnnotationName + " is empty!");
        }
    }
}

