Macro names should adhere to standard naming conventions.
They should start with an uppercase letter and consist of uppercase letters and underscores only.

# Why is This a Problem?
Macro names should be easily distinguishable from normal variable/function/type names and make it clear that using the construct requires careful consideration. 

# How Can I Resolve This?
You could rename the macro.

Often, depending on the implementation language, other concepts might be better suited than a macro (e.g., defining a constant with a type instead).

# Where Can I Learn More?

- [C Coding Standard: #define and Macro Names](https://users.ece.cmu.edu/~eno/coding/CCodingStandard.html#mnames)
- [Google C++ Style Guide: Macro Names](https://google.github.io/styleguide/cppguide.html#Macro_Names)
- [Guideline: C++ Core Guidelines: ES.32 - Use `ALL_CAPS` for all macro names](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines#es32-use-all_caps-for-all-macro-names)