The use of hard-coded passwords increases the possibility of password
guessing tremendously. This plugin test looks for all string literals and
checks the following conditions:

- assigned to a variable that looks like a password
- assigned to a dict key that looks like a password
- assigned to a class attribute that looks like a password
- used in a comparison with a variable that looks like a password

Variables are considered to look like a password if they have match any one
of:

- "password"
- "pass"
- "passwd"
- "pwd"
- "secret"
- "token"
- "secrete"

Note: this can be noisy and may generate false positives.

**Config Options:**

None

## Example


In the following code snippet the issue is: Possible hardcoded password '(root)'
For more information on this see: CWE-259 (https://cwe.mitre.org/data/definitions/259.html)
``` python
def someFunction2(password):
    if password == "root":
        print("OK, logged in")
```
## see also:

- https://www.owasp.org/index.php/Use_of_hard-coded_password
- https://cwe.mitre.org/data/definitions/259.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added
