This plugin is part of a family of tests that detect the use of known bad
* <a href='checks/checks/?languages=PYTHON&tools=BANDIT&rule=bandit.B502'>ssl_with_bad_version</a>
a complete discussion. Specifically, This plugin test scans for specific
methods in Python's native SSL/TLS support and the pyOpenSSL module that
configure the version of SSL/TLS protocol to use. These methods are known
to provide default value that maximize compatibility, but permit use of the
aforementioned broken protocol versions. A LOW severity warning will be
reported whenever this is detected.

**Config Options:**

This test shares the configuration provided for the standard
* <a href='checks/checks/?languages=PYTHON&tools=BANDIT&rule=bandit.B502'>ssl_with_bad_version</a>
documentation.

## Example


In the following code snippet the issue is: ssl.wrap_socket call with no SSL/TLS protocol version
specified, the default SSLv23 could be insecure, possible security
issue.
For more information on this see: CWE-327 (https://cwe.mitre.org/data/definitions/327.html)
``` python

 ssl.wrap_socket()

```
## see also:

- :func:`ssl_with_bad_version`
- :func:`ssl_with_bad_defaults`
- https://heartbleed.com/
- https://en.wikipedia.org/wiki/POODLE
- https://security.openstack.org/guidelines/dg_move-data-securely.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added
