<h2>Why is this an issue?</h2>
<p>In the interests of keeping code clean, the simplest possible conditional syntax should be used. That means</p>
<ul>
  <li> using the <code>??=</code> operator for a self-assign-if-not-null operation, </li>
  <li> using the <code>??</code> operator for an assign-if-not-null operation, and </li>
  <li> using the ternary operator <code>?:</code> for assignment to a single variable. </li>
</ul>
<h3>Noncompliant code example</h3>
<pre>
object a = null, b = null, x;

if (a != null) // Noncompliant; needlessly verbose
{
  x = a;
}
else
{
  x = b;
}

x = a != null ? a : b; // Noncompliant; better but could still be simplified

x = (a == null) ? new object() : a; // Noncompliant

if (condition) // Noncompliant
{
  x = a;
}
else
{
  x = b;
}

if (a == null)  // Noncompliant
    a = new object();

var y = null ?? new object(); // Noncompliant

a = a ?? new object();  // Noncompliant for C# 8
</pre>
<h3>Compliant solution</h3>
<pre>
object x;

x = a ?? b;
x = a ?? b;
x = a ?? new object();
x = condition ? a : b;
a ??= new object();
var y = new object();
a ??= new object();
</pre>

