﻿## SA1002

<table>
<tr>
  <td>TypeName</td>
  <td>SA1002SemicolonsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1002</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The spacing around a semicolon is incorrect, within a C# code file.

## Rule description

A violation of this rule occurs when the spacing around a semicolon is incorrect.

A semicolon should always be followed by a single space, except in the following cases:

* The semicolon is the last character on the line
* The semicolon followed by a closing parenthesis

A semicolon should never be preceded by any whitespace, unless it is the first character on the line.

## How to fix violations

To fix a violation of this rule, ensure that the semicolon is followed by a single space, and is not preceded by any space.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1002:SemicolonsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1002 // SemicolonsMustBeSpacedCorrectly
#pragma warning restore SA1002 // SemicolonsMustBeSpacedCorrectly
```
