﻿## SA1203

<table>
<tr>
  <td>TypeName</td>
  <td>SA1203ConstantsMustAppearBeforeFields</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1203</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

A constant field is placed beneath a non-constant field.

## Rule description

A violation of this rule occurs when a constant field is placed beneath a non-constant field. Constants should be placed above fields to indicate that the two are fundamentally different types of elements with different considerations for the compiler, different naming requirements, etc.

## How to fix violations

To fix an instance of this violation, place all constants above all fields.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1203:ConstantsMustAppearBeforeFields", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1203 // ConstantsMustAppearBeforeFields
#pragma warning restore SA1203 // ConstantsMustAppearBeforeFields
```
