﻿## SA1406

<table>
<tr>
  <td>TypeName</td>
  <td>SA1406DebugFailMustProvideMessageText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1406</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A call to Debug.Fail in C# code does not include a descriptive message.

## Rule description

A violation of this rule occurs when the code contains a call to Debug.Fail which does not provide a description for the end-user. For example, the following call includes a description message:

```csharp
Debug.Fail("The code should never reach this point.");
```

## How to fix violations

To fix an instance of this violation, add a descriptive message to the Debug.Fail call which will appear to the end user when the assert is fired.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1406:DebugFailMustProvideMessageText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1406 // DebugFailMustProvideMessageText
#pragma warning restore SA1406 // DebugFailMustProvideMessageText
```
