<h2>Why is this an issue?</h2>
<p>A non-serializable <code>Comparator</code> can prevent an otherwise-<code>Serializable</code> ordered collection from being serializable. Since the
overhead to make a <code>Comparator</code> serializable is usually low, doing so can be considered good defensive programming.</p>
<h3>Noncompliant code example</h3>

```java
public class FruitComparator implements Comparator<Fruit> {  // Noncompliant
  int compare(Fruit f1, Fruit f2) {...}
  boolean equals(Object obj) {...}
}
```
<h3>Compliant solution</h3>

```java
public class FruitComparator implements Comparator<Fruit>, Serializable {
  private static final long serialVersionUID = 1;

  int compare(Fruit f1, Fruit f2) {...}
  boolean equals(Object obj) {...}
}
```