<h2>Why is this an issue?</h2>
<p>The difference between <code>private</code> and <code>protected</code> visibility is that child classes can see and use <code>protected</code>
members, but they cannot see <code>private</code> ones. Since a <code>final</code> class will have no children, marking the members of a
<code>final</code> class <code>protected</code> is confusingly pointless.</p>
<p>Note that the <code>protected</code> members of a class can also be seen and used by other classes that are placed within the same package, this
could lead to accidental, unintended access to otherwise private members.</p>
<h3>Noncompliant code example</h3>

```java
public final class MyFinalClass {

  protected String name = "Fred";  // Noncompliant
  protected void setName(String name) {  // Noncompliant
    // ...
  }
```
<h3>Compliant solution</h3>

```java
public final class MyFinalClass {

  private String name = "Fred";
  public void setName(String name) {
    // ...
  }
```
<h3>Exceptions</h3>
<p>Members annotated with&nbsp;<code>@VisibleForTesting</code> annotation are ignored, as it indicates that visibility has been purposely relaxed to
make the code testable.</p>

```java
public final class MyFinalClass {
  @VisibleForTesting
  protected Logger logger; // Compliant

  @VisibleForTesting
  protected int calculateSomethingComplex(String input) { // Compliant
    // ...
  }
}
```