<h2>Why is this an issue?</h2>
<p>Type parameters that aren’t used are dead code, which can only distract and possibly confuse developers during maintenance. Therefore, unused type
parameters should be removed.</p>
<h3>Noncompliant code example</h3>

```java
int <T> Add(int a, int b) // Noncompliant; <T> is ignored
{
  return a + b;
}
```
<h3>Compliant solution</h3>

```java
int Add(int a, int b)
{
  return a + b;
}
```