<h2>Why is this an issue?</h2>
<p>Tests should always:</p>
<ul>
  <li> Make sure that production code behaves as expected, including edge cases. </li>
  <li> Be easy to debug, i.e. understandable and reproducible. </li>
</ul>
<p>Using random values in tests will not necessarily check edge cases, and it will make test logs a lot harder to read. It is better to use easily
readable hardcoded values. If this makes your code bigger you can use helper functions.</p>
<p>There is one valid use case for random data in tests: when testing every value would make tests impractically slow. In this case the best you can
do is use random to test every value on the long run. You should however make sure that random values are logged so that you can reproduce failures.
Some libraries exist to make all this easier. You can for example use property-based testing libraries such as <a
href="https://github.com/jlink/jqwik">jqwik</a>.</p>
<p>This rule raises an issue when <code>new Random()</code> or <code>UUID.randomUUID()</code> are called in test code.</p>
<h3>Noncompliant code example</h3>

```java
int userAge = new Random().nextInt(42);  // Noncompliant
UUID userID = UUID.randomUUID(); // Noncompliant
```
<h3>Compliant solution</h3>

```java
int userAge = 31;
UUID userID = UUID.fromString("00000000-000-0000-0000-000000000001");
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://phauer.com/2019/modern-best-practices-testing-java/#use-fixed-data-instead-of-randomized-data">Modern Best Practices for
  Testing in Java - Philipp Hauer</a> </li>
  <li> <a href="https://jqwik.net/">Jqwik test engine</a> </li>
</ul>