<h2>Why is this an issue?</h2>
<p>Operator precedence determines the order in which different operators are evaluated when an expression contains multiple ones. It helps determine
how the expression is parsed and executed. JavaScript follows a specific set of rules to determine operator precedence.</p>
<p>Not being aware of JavaScript’s operator precedence rules can lead to unexpected and potentially incorrect results when evaluating expressions.
This is common when misapplying the logical negation operator (<code>!</code>). For instance, consider the difference between <code>!key in
dict</code> and <code>!(key in dict)</code>. The first looks for a boolean value (<code>!key</code>) in <code>dict</code>, and the other looks for a
string and inverts the result. The same applies for <code>!obj instanceof SomeClass</code>.</p>
<p>This rule raises an issue when the left operand of an <code>in</code> or <code>instanceof</code> operator is negated with <code>!</code>.</p>

```js
if (!"prop" in myObj) { // Noncompliant: checks whether !"prop", that is, false is in myObj
  doTheThing(); // this block is never executed
}

if (!foo instanceof MyClass) { // Noncompliant: "!foo" returns a boolean, which is not an instance of anything
  doTheOtherThing(); // this block is never executed either
}
```
<p>You should use parentheses to force the order of evaluation of expressions mixing negation and <code>in</code> or <code>instanceof</code>
operators.</p>

```js
if (!("prop" in myObj)) {
  doTheThing();
}

if (!(foo instanceof MyClass)) {
  doTheOtherThing();
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Operator_precedence">Operator
  precedence</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Operator_precedence#table">Operator
  precedence table</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_NOT">Logical NOT
  (<code>!</code>)</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/instanceof"><code>instanceof</code></a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/in"><code>in</code> operator</a> </li>
</ul>