<h2>Why is this an issue?</h2>
<p>Non-interactive DOM elements are HTML elements that are not designed to be interacted with by the user, for instance <code>&lt;div&gt;</code>,
<code>&lt;span&gt;</code>, and <code>&lt;footer&gt;</code>, etc. They are typically used to structure content and do not have built-in interactivity
or keyboard accessibility.</p>
<p>Interactive handlers, on the other hand, are event handlers that respond to user interactions. These include handlers like <code>onClick</code>,
<code>onKeyDown</code>, <code>onMouseUp</code>, and more. When these handlers are added to an HTML element, they make the element respond to the
specified user interaction.</p>
<p>When non-interactive elements have interactive handlers, it can lead to several problems:</p>
<ul>
  <li> Unexpected behavior: Non-interactive elements are not designed to be interactive, so adding interactive handlers can cause unexpected behavior.
  For example, non-interactive elements do not naturally receive keyboard focus, so keyboard users might not be able to activate the handler. </li>
  <li> Confusing for assistive technologies: Assistive technologies might not announce non-interactive elements with interactive handlers correctly.
  This can make it difficult for users to understand how to interact with the content. </li>
  <li> Violation of HTML standards: Using interactive handlers on non-interactive elements can be seen as a misuse of HTML, as it goes against the
  intended use of these elements. </li>
</ul>
<p>By enforcing that interactive handlers are only used on interactive elements, this rule helps create a more predictable and user-friendly
experience for all users, and ensures that web content adheres to accessibility standards and best practices.</p>
<h2>How to fix it</h2>
<p>The simplest and most recommended way is to replace the non-interactive elements with interactive ones. If for some reason you can’t replace the
non-interactive element, you can add an interactive <code>role</code> attribute to it and manually manage its keyboard event handlers and focus.
Common interactive roles include <code>button</code>, <code>link</code>, <code>checkbox</code>, <code>menuitem</code>, <code>menuitemcheckbox</code>,
<code>menuitemradio</code>, <code>option</code>, <code>radio</code>, <code>searchbox</code>, <code>switch</code>, and <code>textbox</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
<div onClick={() => {}} />; // Noncompliant
```
<h4>Compliant solution</h4>

```js
<div onClick={() => {}} role="button" />;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/name-role-value">Name, Role, Value</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">WAI-ARIA Roles</a> </li>
</ul>