<h2>Why is this an issue?</h2>
<p>Jump statements, such as <code>return</code>, <code>break</code> and <code>continue</code>, are used to change the normal flow of execution in a
program. They are useful because they allow for more complex and flexible code. However, it is important to use jump statements judiciously, as
overuse or misuse can make code difficult to read and maintain.</p>
<p>Jump statements are redundant when they do not affect the program flow or behavior.</p>

```ts
function redundantJump(x) {
  if (x == 1) {
    console.log("x == 1");
    return; // Noncompliant: The function would return 'undefined' also without this 'return' statement
  }
}
```
<p>Remove any jump statements that are unnecessary or redundant.</p>

```ts
function redundantJump(x) {
  if (x == 1) {
    console.log("x == 1");
  }
}
```
<h3>Exceptions</h3>
<ul>
  <li> <code>break</code> and <code>return</code> inside <code>switch</code> statements are ignored, because they are often used for consistency.
  </li>
  <li> <code>continue</code> associated with a label is ignored, because it is usually used for clarity. </li>
  <li> Jump statements are ignored when they are the only statement inside a block. </li>
</ul>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/continue"><code>continue</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/break"><code>break</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/return"><code>return</code></a> </li>
</ul>