<p>Statements with no side effects and no change of control flow do not contribute to the functionality of the code and can indicate a programming
error.</p>
<h2>Why is this an issue?</h2>
<p>When writing code, it is important to ensure that each statement serves a purpose and contributes to the overall functionality of the program. When
they have no side effects or do not change the control flow, they can either indicate a programming error or be redundant:</p>
<ol>
  <li> The code does not behave as intended: The statements are expected to have an effect but they do not. This can be caused by mistyping,
  copy-and-paste errors, etc. </li>
  <li> The statements are residual after a refactoring. </li>
</ol>
<h3>Exceptions</h3>
<p>The rule does not raise an issue on statements containing only a semicolon (<code>;</code>).</p>
<h2>How to fix it</h2>
<p>Identify statements that do not contribute to the functionality of the code and verify if they are intended to be part of the logic. If they are,
there is a bug to be fixed. If they are not, then they are redundant and should be removed.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function getResult() {
    let result = 42;
    if (shouldBeZero()) {
        result == 0; // Noncompliant: no side effect, was an assignment intended?
    }
    return result;
}
```

```ts
var msg = "Hello, "
  "World!"; // Noncompliant; have we forgotten '+' operator on previous line?
```
<h4>Compliant solution</h4>

```ts
function getResult() {
    let result = 42;
    if (shouldBeZero()) {
        result = 0; // Compliant
    }
    return result;
}
```

```ts
var msg = "Hello, " +
  "World!"; // Compliant
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/482">CWE-482 Comparing instead of Assigning</a> </li>
</ul>