We recommend you use the  prebuilt images at https://hub.docker.com/r/cqse/teamscale/

# How to create the Docker image

The Dockerfile expects the `teamscale` folder from Teamscale's zip in its working directory when you run `docker build`

# Updating docker base image
Note that colleagues may also work on changes to the base image on a parallel feature branch. To avoid overwriting their image, before updating the version number, check in the [Google Cloud Console](https://console.cloud.google.com/artifacts/docker/cqse-build/europe-west1/teamscale/teamscale-base?rapt=AEjHL4PtTNyzpaD-BQa6CbvIJjft-e3uFXPzz1PQkmdsKy3g6MhOIuqruFoS9wMhbDEXiUhV5uGQpBfBw9ZVeUYsOvDRs6O0p-IFO3diFPki6HQHgGOeR9o) which one is the next free version number.
If you do not plan to merge your changes soon, consider adding a suffix such as your ticket number (e.g. v43-ts25731) to make conflicts even less likely.

Follow these steps to adjust the base image:

1. Identify the next free version number:
    1. Check
       the [Google Cloud Console](https://console.cloud.google.com/artifacts/docker/cqse-build/europe-west1/teamscale/teamscale-base?rapt=AEjHL4PtTNyzpaD-BQa6CbvIJjft-e3uFXPzz1PQkmdsKy3g6MhOIuqruFoS9wMhbDEXiUhV5uGQpBfBw9ZVeUYsOvDRs6O0p-IFO3diFPki6HQHgGOeR9o)
       for the biggest existing version
    2. If the current version is the biggest version, use the next increment, e.g., v44 → v45
    3. If there is already a bigger version, use the next patch increment, e.g., v44 → v44.1 or v44.1 → v44.2
    4. If you do not plan to merge your changes soon, consider adding a suffix such as your ticket number (e.g.,
       v44-pre-ts25731) to avoid conflicts with other developers.
2. Increment the `TEAMSCALE_BASE_IMAGE_VERSION` version (Docker tag) in the build script (`.gitlab-ci.yml`) to your selected
   version
3. Update the version in the first line of the main Dockerfile `server/Dockerfile` and the target
   `server/Dockerfile.target`
4. Commit and Push
5. Execute the `teamscale:dist/base-image/...` jobs (all other jobs will fail)
6. Execute the `teamscale:dist/gcp/base-image` job (might run automatically)

In case of any questions or problems, please reach out to *#def-infra*

## Installing new tools
Create a new RUN command for every new tool you add. If you are using apt to install programs, don't forget to use
`apt-get update` before and `rm -rf /var/lib/apt/lists/*` at the end.
A single RUN command might reduce the redundancy but over time it's getting more cluttered, and it's no longer
clear what package is installed for which tool.  

Add a test for the tool and its desired version in the pipeline job `.template:teamscale:dist/base-image:`
in `.gitlab/ci/teamscale.dist.gitlab-ci.yml`.

If you are installing it via apt, we are always using the flag `--no-install-recommends` to prevent too much bloat.
Add everything that is needed directly, like this we have a better overview over what is being installed.  

Make sure to provide a (more or less) specific version. You can look up any current version with `apt-cache policy <package>`
Better to give a wildcard version, such that the major version is fixed than the very specific version which
is subject to change.  
Older version can be found on the launchpad website: https://launchpad.net/ubuntu/<release>/<architecture>/<package>
e.g. https://launchpad.net/ubuntu/jammy/amd64/cppcheck

# Pitfalls
## Don't start the base image job before incrementing the version
Don't start `teamscale:dist/base` without incrementing the version in `.gitlab-ci.yml` and `server/Dockerfile` first, 
otherwise you might update the currently used base for everybody. If that happens, and you introduced breaking changes, every pipeline might break ;-).  
However, in that case, you can just go to a pipeline unaffected by your changes and start the jobs under `teamscale:dist/base-image`
again to fix it.

## Changes to base on branches other than master
If you are not on master and upstream release branches have a different version, you have to increment and release
the image on those branches then as well to introduce your changes. 
You better do this with a separate merge request and branch where you merge your changes into, 
better than relying on the daily merges.
