import{_ as t,c as o,ak as i,o as n}from"./chunks/framework.AfHpRKMk.js";const a="/assets/plcCodeExample.BuJb0ghC.png",r="/assets/simulinkGeneratedCodeFinding.DAWX1bsE.png",d="/assets/simulinkGeneratedCodeCoverage.Cia5QpHr.png",l="/assets/SimulinkGeneratedCodeNewAnalysisProfile1.DcryvJmc.png",c="/assets/SimulinkGeneratedCodeNewAnalysisProfile2.DoTxlux3.png",s="/assets/SimulinkGeneratedCodeProjectConfig.32w28SFg.png",w=JSON.parse('{"title":"Mapping from generated Code to Simulink Models","description":"","frontmatter":{"title":"Mapping from generated Code to Simulink Models"},"headers":[],"relativePath":"howto/generated-code-tracing-for-simulink/index.md","filePath":"howto/generated-code-tracing-for-simulink/index.md"}'),m={name:"howto/generated-code-tracing-for-simulink/index.md"};function h(p,e,g,u,f,k){return n(),o("div",null,[...e[0]||(e[0]=[i('<h1 id="simulink-models-and-code-generation" tabindex="-1">Simulink Models and Code Generation <a class="header-anchor" href="#simulink-models-and-code-generation" aria-label="Permalink to &quot;Simulink Models and Code Generation&quot;">​</a></h1><p>Simulink is often used to model controllers for complex physical systems. Since the modelled logic will be used in embedded controllers, there are code-generation tools that generate low-level code from the Simulink models.</p><p>This page describes how Teamscale supports connecting the generated code to the Simulink model elements from which the code was generated.</p><nav class="table-of-contents"><ul><li><a href="#problem-description">Problem Description</a></li><li><a href="#linking-generated-code-to-simulink-models">Linking generated code to Simulink models</a></li><li><a href="#setup-of-the-generated-code-tracing">Setup of the generated-code tracing</a></li><li><a href="#limitations">Limitations</a></li></ul></nav><h2 id="problem-description" tabindex="-1">Problem Description <a class="header-anchor" href="#problem-description" aria-label="Permalink to &quot;Problem Description&quot;">​</a></h2><p>In a typical use case, the code generated from a Simulink model will not be maintained directly. If there are problems, they will be addressed in the Simulink model and the next generator run will overwrite the generated code. The generated code is not directly maintained and therefore, code-readability findings on the generated code are not interesting.</p><p>However, findings concerning correctness or performance in the generated code are interesting and should be addressed. Even more interesting would be code-coverage of the generated code. How much of the original Simulink model is actually covered by testing of the generated code?</p><h2 id="linking-generated-code-to-simulink-models" tabindex="-1">Linking generated code to Simulink models <a class="header-anchor" href="#linking-generated-code-to-simulink-models" aria-label="Permalink to &quot;Linking generated code to Simulink models&quot;">​</a></h2><p>Teamscale supports linking &quot;back&quot; from generated code to the Simulink model for the code generator <a href="https://de.mathworks.com/help/plccoder/index.html" target="_blank" rel="noreferrer"><code>PLCcoder</code></a> from Mathworks. PLCcoder generates Structured Text code (IEC 61131-3). The code contains hints that allow us to determine the Simulink blocks from which the code was generated. <img src="'+a+'" alt="Generated-Code Example" width="976" height="158" data-zoom="true"></p><p>To enable this, Teamscale requires a special meta-information <code>traceInfo.mat</code> file that PLCcoder generates when executed with the <code>Generate traceability option</code>.</p><p>If the file is provided, Teamscale will map code regions in the generated code to Simulink blocks. For any mapped code region:</p><ul><li>Findings on the code will be copied and attached to the Simulink blocks. <img src="'+r+'" alt="Generated-Code Example" width="861" height="107" data-zoom="true"></li><li>Coverage on the code will be mapped to the corresponding Simulink model. The coverage per model will appear in the new metric <code>Model Line Coverage</code>. <img src="'+d+'" alt="Generated-Code Example" width="987" height="147" data-zoom="true"></li><li>The code view in the Teamscale UI will provide a link from the comment (e.g., <code>&#39;&lt;S1&gt;/Weight&#39;</code>) to the Simulink block. Use CTRL + left click to follow the link.</li></ul><h2 id="setup-of-the-generated-code-tracing" tabindex="-1">Setup of the generated-code tracing <a class="header-anchor" href="#setup-of-the-generated-code-tracing" aria-label="Permalink to &quot;Setup of the generated-code tracing&quot;">​</a></h2><p>To enable generated-code tracing, several options need to be enabled in the project configuration and analysis profile.</p><ol><li><p>In the analysis profile editor, enable analysis for the languages <code>IEC 61131-3 ST</code> and <code>Simulink and Stateflow</code> by selecting them from <code>Language &amp; Tool Enablement</code>. IEC is required to get findings/coverage to be mapped. Simulink is required to have something to map the findings/coverage to.</p><p><img src="'+l+'" alt="Generated-Code Example" width="972" height="550" data-zoom="true"></p></li><li><p>As a final step in the analysis profile editor, make sure to enable the option <code>Enable Simulink tracing</code> under <code>Advanced Options</code>.</p><p><img src="'+c+'" alt="Generated-Code Example" width="572" height="578"></p></li><li><p>In the <code>Included file names</code> option in the project settings, make sure to include your IEC files (e.g., <code>**.st</code>) and your Simulink files (e.g., <code>**.slx</code>).</p></li><li><p>In the <code>Analysis report mapping</code> option in the project settings (advanced settings), add the entry <code>**/traceInfo.mat -&gt; SIMULINK_MAT</code>.</p><p><img src="'+s+'" alt="Generated-Code Example" width="632" height="219" data-zoom="true"></p></li><li><p>The generated Structured Text code and the corresponding <code>traceInfo.mat</code> file must be committed to the analyzed code repository or to another content source configured in the Teamscale project (e.g., <a href="./../uploading-external-data/#import-via-artifactory-s3">Artifactory/S3</a>). Since code links might change over time, the <code>traceInfo.mat</code> file should be regenerated and committed each time the code is regenerated. When code and <code>traceInfo.mat</code> file are committed they should ideally match the Simulink models stored in the current repository commit.</p></li></ol><h2 id="limitations" tabindex="-1">Limitations <a class="header-anchor" href="#limitations" aria-label="Permalink to &quot;Limitations&quot;">​</a></h2><p>Due to the rather complex relations between Simulink models, generated code, and the <code>traceInfo.mat</code> file, we need to make some assumptions on the usage scenarios. These assumptions lead to the following limitations of the code-tracing feature:</p><ol><li>We can consume only one <code>traceInfo.mat</code> file per project and branch. This means that at any time only one <code>traceInfo.mat</code> file will be used by Teamscale. If a new commit introduces a new file, its information will overwrite the information from any previous file (even if they have different file paths and the &quot;old&quot; file still exists in the repository).</li><li>If the Simulink models change without new code generation, then Teamscale can&#39;t maintain correct tracing. Teamscale will provide the old links as far as possible, but over time more and more links will break until new generated code is committed.</li></ol>',18)])])}const S=t(m,[["render",h]]);export{w as __pageData,S as default};
