import{_ as t,c as s,ak as a,o}from"./chunks/framework.AfHpRKMk.js";const u=JSON.parse('{"title":"Teamscale Java Profiler - Testwise Coverage Recording","description":"","frontmatter":{},"headers":[],"relativePath":"reference/coverage-profilers/teamscale-java-profiler/testwise-coverage-recording/index.md","filePath":"reference/coverage-profilers/teamscale-java-profiler/testwise-coverage-recording/index.md"}'),i={name:"reference/coverage-profilers/teamscale-java-profiler/testwise-coverage-recording/index.md"};function n(r,e,l,c,d,h){return o(),s("div",null,[...e[0]||(e[0]=[a(`<h1 id="teamscale-java-profiler-testwise-coverage-recording" tabindex="-1">Teamscale Java Profiler - Testwise Coverage Recording <a class="header-anchor" href="#teamscale-java-profiler-testwise-coverage-recording" aria-label="Permalink to &quot;Teamscale Java Profiler - Testwise Coverage Recording&quot;">​</a></h1><p>The Teamscale Java Profiler can be used to record <a href="./../../../../glossary/#testwise-coverage">testwise coverage</a> which is needed to set up Test Impact Analysis or Pareto with Teamscale. If you are unfamiliar with Test Impact Analysis, please have a look at our TIA <a href="./../../../../tutorial/tia-java/">tutorial</a> and <a href="./../../../../howto/providing-testwise-coverage/">how-to</a> first.</p><div class="tip custom-block"><p class="custom-block-title">Gradle &amp; Maven</p><p>If you want to set up Test Impact Analysis and are using Gradle or Maven, it is usually easier to use our respective <a href="./../../../integrations/gradle-plugin/">Gradle</a> or <a href="./../../../integrations/maven-plugin/">Maven</a> plugin.</p></div><h2 id="setup" tabindex="-1">Setup <a class="header-anchor" href="#setup" aria-label="Permalink to &quot;Setup&quot;">​</a></h2><p>To enable testwise coverage collection, the <code>mode</code> option must be set to <code>testwise</code>. Furthermore, the test system (the application executing the test specification) <strong>has to</strong> inform the profiler of when a test started and finished via the <a href="#api-endpoints">REST API</a>. To be able to send the profiler test events, you must set the following additional options in the profiler configuration:</p><ul><li><code>http-server-port</code>: the port at which the profiler should start an HTTP server that listens for test events (Recommended port is 8123)</li><li><code>class-dir</code>: the path under which all class files of the profiled application are stored on the test environment. Can be a directory or a Jar/War/Ear/... file. Separate multiple paths with a semicolon (for details, please see the <a href="./../#path-format">path format section</a>).</li></ul><p>To record testwise coverage, you need to call the profiler API endpoints in the following order:</p><ol><li>(Optionally: <code>[POST] /testrun/start</code> to get a list of impacted tests)</li><li><code>[POST] /test/start</code></li><li><code>[POST] /test/end</code></li><li>Repeat step 2 and 3 until all the tests ran through</li><li><code>[POST] /testrun/end</code></li></ol><p>Have a look at the <a href="#api-endpoints">API section</a> for more explanations about these endpoints. For additional configuration options, have a look at the <a href="#options">options section</a>.</p><h2 id="api-endpoints" tabindex="-1">API Endpoints <a class="header-anchor" href="#api-endpoints" aria-label="Permalink to &quot;API Endpoints&quot;">​</a></h2><p>These are the relevant API endpoints to generate testwise coverage reports. Have a look at our advanced setup page for more information on the profilers <a href="./../advanced-setup/#rest-api">REST API</a>.</p><ul><li><p><code>[GET] /test</code> Returns the testPath of the current test. The result will be empty when the test already finished or was not started yet.</p></li><li><p><code>[POST] /testrun/start</code> If you configured a connection to Teamscale via the <code>teamscale-</code> options, this will fetch impacted tests from Teamscale and return them in the response body. You may optionally provide a list of all available test cases in the body of the request. These will also be used to generate the testwise coverage report in <code>[POST] /testrun/end</code>. The format of the request body is:</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;clusterId&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&lt;ID of the cluster the test belongs to&gt;&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;uniformPath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&lt;Unique name of the test case&gt;&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;sourcePath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&lt;Optional: Path to the source of the test&gt;&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;content&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&lt;Optional: Value to detect changes to the test, e.g. hash code, revision, ...&gt;&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ]</span></span></code></pre></div><p>Additionally, you may pass the following optional URL query parameters:</p><ul><li><code>include-non-impacted</code>: If this is <code>true</code>, will not perform test-selection, only test-prioritization.</li><li><code>baseline</code>: The baseline in the form <a href="./../../../../glossary/#branch-and-timestamp"><code>branch:timestamp</code></a> to indicate the time since which changes should be considered. If not given, the time since the last uploaded testwise coverage report is used.</li></ul></li><li><p><code>[POST] /testrun/end?partial=true</code> If you configured a connection to Teamscale via the <code>teamscale-</code> options and enabled <code>tia-mode=teamscale-upload</code>, this will upload a testwise coverage report to Teamscale. <code>partial</code> describes whether the recorded tests represent a subset of all tests i.e. only impacted tests were executed. This tells Teamscale to keep tests even if they are not present in the latest report. Defaults to <code>false</code>.</p></li><li><p><code>[POST] /test/start/{uniformPath}</code> Signals to the profiler that the test with the given <a href="./../../../../glossary/#uniformpath">uniformPath</a> is about to start.</p></li><li><p><code>[POST] /test/end/{uniformPath}</code> Signals to the profiler that the test with the given <a href="./../../../../glossary/#uniformpath">uniformPath</a> has just finished. The body of the request may optionally contain the test execution result in json format:</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;result&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;ERROR&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;message&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&lt;stacktrace&gt;|&lt;ignore reason&gt;&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p><code>result</code> can be one of:</p><ul><li><code>PASSED</code> Test execution was successful.</li><li><code>IGNORED</code> The test is currently marked as &quot;do not execute&quot; (e.g. JUnit <code>@Ignore</code> or <code>@Disabled</code>).</li><li><code>SKIPPED</code> Caused by a failing assumption.</li><li><code>FAILURE</code> Caused by a failing assertion.</li><li><code>ERROR</code> Caused by an error during test execution (e.g. exception thrown).</li></ul></li></ul><div class="warning custom-block"><p class="custom-block-title">UniformPath</p><p>The <code>uniformPath</code> parameter must be url encoded. E.g. <code>com/example/MyTest/testSomething</code> -&gt; <code>http://localhost:8123/test/start/com%2Fexample%2FMyTest%2FtestSomething</code>.</p></div><h2 id="options" tabindex="-1">Options <a class="header-anchor" href="#options" aria-label="Permalink to &quot;Options&quot;">​</a></h2><p>You can select how the testwise coverage report is generated by setting the <code>tia-mode</code> option to either:</p><ul><li><code>teamscale-upload</code>: the profiler will upload the testwise report to Teamscale once you call the <code>POST /testrun/end</code> REST endpoint. This option is the most convenient of the different modes as the profiler handles all aspects of report generation and the upload to Teamscale for you. This mode may slow down the startup of the system under test and result in a larger memory footprint than the <code>exec-file</code> mode.</li><li><code>exec-file</code> (default): The profiler stores the coverage in a binary <code>*.exec</code> file within the <code>out</code> directory. This is most useful when running tests in a CI/CD pipeline where the build tooling can later batch-convert all <code>*.exec</code> files and upload a testwise coverage report to Teamscale or in situations where the profiler must consume as little memory and CPU as possible and thus cannot convert the execution data to a report as required by the other options. It is, however, less convenient as you have to convert the <code>*.exec</code> files yourself.</li><li><code>disk</code>: The profiler stores the testwise coverage in JSON <code>*.json</code> files within the <code>out</code> directory. This is most useful when running tests in a CI/CD pipeline where the testwise coverage is to be provided in storage systems (such as S3) using custom upload scripts.</li><li><code>http</code>: the profiler converts the coverage collected during a test in-process and returns it as a JSON in the response to the <code>[POST] /test/end/...</code> request. This allows the caller to handle merging coverage of multiple tests into one testwise coverage report, e.g. in situations where more than one profiler is running at the same time (e.g. profiling across multiple microservices.) This option may slow down the startup of the system under test and result in a larger memory footprint than the <code>exec-file</code> mode. The response will be part of a <a href="./../../../upload-formats-and-samples/testwise-coverage/version_1/#sample-file-for-testwise-coverage">testwise coverage</a> report, without the surrounding <code>tests</code> array.</li></ul><p>To convert the <code>.exec</code> files produced by <code>tia-mode=exec-file</code>, you can run the <code>bin/convert</code> tool. Run <code>bin/convert --help</code> to see all available command line options.</p>`,17)])])}const g=t(i,[["render",n]]);export{u as __pageData,g as default};
