import{_ as s,c as i,b as t,x as a,O as n,ak as r,L as c,o as l}from"./chunks/framework.AfHpRKMk.js";const p="/assets/project-advanced-settings.DbjCcLYr.png",y=JSON.parse('{"title":"Changing a Project ID","description":"Explains the motivation of changing a Teamscale Project ID, and things to watch out for in that scenario.","frontmatter":{"title":"Changing a Project ID","description":"Explains the motivation of changing a Teamscale Project ID, and things to watch out for in that scenario."},"headers":[],"relativePath":"reference/ui/project/changing-project-id/index.md","filePath":"reference/ui/project/changing-project-id/index.md"}'),h={name:"reference/ui/project/changing-project-id/index.md"},d={id:"how-to-change-a-teamscale-project-id",tabindex:"-1"};function m(g,e,f,u,j,I){const o=c("Badge");return l(),i("div",null,[t("h1",d,[e[0]||(e[0]=a("How to Change a Teamscale Project ID ",-1)),n(o,{text:"since 7.1",type:"tip"}),e[1]||(e[1]=a()),e[2]||(e[2]=t("a",{class:"header-anchor",href:"#how-to-change-a-teamscale-project-id","aria-label":'Permalink to "How to Change a Teamscale Project ID <Badge text="since 7.1" type="tip"/>"'},"​",-1))]),e[3]||(e[3]=r('<p>Teamscale supports a flexible project ID system that was introduced with its 7.1 release version. Setting and changing these IDs manually is an expert feature that is not necessary during regular operation. However, experienced project administrators may use it to deal with several complex use cases.</p><nav class="table-of-contents"><ul><li><a href="#use-case-example-managing-project-copies">Use Case Example: Managing Project Copies</a></li><li><a href="#teamscale-project-id-paradigms">Teamscale Project ID Paradigms</a></li><li><a href="#implications-of-project-id-changes">Implications of Project ID Changes</a></li></ul></nav><h2 id="use-case-example-managing-project-copies" tabindex="-1">Use Case Example: Managing Project Copies <a class="header-anchor" href="#use-case-example-managing-project-copies" aria-label="Permalink to &quot;Use Case Example: Managing Project Copies&quot;">​</a></h2><p>Special circumstances may make it necessary to transparently create a copy of a Teamscale project on the same Teamscale instance as the original project, and to switch between these two projects in a way that is transparent to the end user.</p><p>For example, sometimes a prolonged reanalysis of a project may not be feasible because of availability requirements. If a change to the analysis profile of such a project needs to be performed, instead a new project can be created that duplicates the settings of the original project (but with an adapted analysis profile).</p><p>After analysis of the new project is completed, the switch from old to new project is performed, after which the user will access the new project rather than the old one. In this way, the necessary changes to the analysis profile can be made without any downtime.</p><h2 id="teamscale-project-id-paradigms" tabindex="-1">Teamscale Project ID Paradigms <a class="header-anchor" href="#teamscale-project-id-paradigms" aria-label="Permalink to &quot;Teamscale Project ID Paradigms&quot;">​</a></h2><p>Each Teamscale project is associated with a project ID. This is also referred to as the <em>primary public project ID</em>. In the Teamscale project configuration, it is displayed in the <strong>Advanced Settings</strong> as the <strong>Project ID</strong> option. This ID is the only one an end user will typically see, as it is the one that is used to define the URL where the project can be accessed. Additionally, this ID will be used in the UI to refer to this project whenever an ID needs to be displayed (for example, in the system logs view).</p><p><img src="'+p+'" alt="Teamscale Project Configuration - Advanced Settings" width="1630" height="732" data-zoom="true"></p><p>In addition to the primary project ID, a project may also have <strong>alternative project IDs</strong>. These can be set in the field directly below the primary ID. A project may have any number of alternative IDs, although these are completely optional.</p><p>The only difference between the primary ID and the alternative IDs is the UI behavior of Teamscale. End users will only see the primary ID of a project, but not the alternative IDs. In all other respects the IDs behave interchangeably. In particular, alternative IDs can be used in REST API calls in place of the primary project ID, and they may be used in URLs to link to the respective Teamscale project. Hence, alternative IDs can be used to preserve backwards compatibility of external systems that reference such URLs.</p><p>The primary and the alternative IDs of a project can be changed freely, as long as they don&#39;t conflict with any other project ID. In other words, project IDs are globally unambiguous over the complete Teamscale instance. ID changes take effect immediately and do not require a reanalysis of the project.</p><h2 id="implications-of-project-id-changes" tabindex="-1">Implications of Project ID Changes <a class="header-anchor" href="#implications-of-project-id-changes" aria-label="Permalink to &quot;Implications of Project ID Changes&quot;">​</a></h2><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p>Even though project IDs can be changed freely, it is not always advisable to do so.</p></div><p>In particular, changing a project ID from <code>original-id</code> to <code>new-id</code> means that end users who have bookmarked the URL <code>https://&lt;teamscale-server&gt;/findings.html#/original-id</code> will no longer be able to access this endpoint, until they have changed it to the new <code>https://&lt;teamscale-server&gt;/findings.html#/new-id</code>. In such cases, it may make sense to add <code>original-id</code> to the set of alternative project IDs when renaming it to <code>new-id</code>, allowing the user to keep the old bookmark. Indeed, preserving backwards compatibility for such URLs is the primary use case of the alternative project IDs. Keep in mind that project ID references may crop up in unexpected places, such as the merge request comments Teamscale can perform in code collaboration platforms, or in automated CI pipeline scripts that upload external data to a specific Teamscale project. Hence, project ID changes should be kept to a minimum to avoid unintentional consequences.</p><p>Another aspect to keep in mind is the issue of <strong>project permissions</strong>. For example, if a specific user group is granted the <strong>view permission</strong> on a specific project, this will be done by project ID. If this project ID is changed, then the users will no longer be able to view the project. If the same project ID is entered as primary or alternative project ID of a second project, then the user group will be able to view the second project, but not the original one. This is the desired behavior for the example scenario mentioned above (migrating a user base transparently from one project to another), but it may not be appropriate for all use cases. Hence, permissions should be checked (and adapted as required) after changing any project ID.</p>',16))])}const w=s(h,[["render",m]]);export{y as __pageData,w as default};
