/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.index.admin.instance_comparison.option.IInstanceComparisonAcceptableDeviationsOption;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="instance-comparison-test-gaps", name="Test Gaps", type=EOptionType.SERVER, category=EOptionCategory.INSTANCE_COMPARISON, orderingHint=500)
@IndexValueClass(containedInBackup=true)
public class InstanceComparisonTestGapOption
implements IInstanceComparisonAcceptableDeviationsOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "instance-comparison-test-gaps";
    @JsonProperty(value="testGaps")
    @OptionFieldDescription(name="Accepted Deviation for Test Gaps", description="How large the deviation of the test gaps may be compared to the remote test gaps. The specification is in decimal numbers.")
    public double testGaps = 0.01;
    @JsonProperty(value="executedMethods")
    @OptionFieldDescription(name="Accepted Deviation for executed methods", description="How large the deviation of the executed methods may be compared to the remote executed methods. The specification is in decimal numbers.")
    public double executedMethods = 0.02;
    @JsonProperty(value="tgaTrend")
    @OptionFieldDescription(name="Accepted Deviation for TGA trends", description="How large the deviation of the TGA trend may be compared to the remote trend. The specification is in decimal numbers.")
    public double tgaTrend = 0.01;

    @Override
    public InstanceComparisonContributionBase.AcceptedComparisonDeviations getAcceptedComparisonDeviations() {
        return new InstanceComparisonContributionBase.AcceptedComparisonDeviations(0.0, this.getAcceptableDeviations(), (PairList<Pattern, Double>)PairList.emptyPairList());
    }

    private Map<String, Double> getAcceptableDeviations() {
        HashMap<String, Double> acceptableDeviations = new HashMap<String, Double>();
        acceptableDeviations.put("30 days TGA", this.testGaps);
        acceptableDeviations.put("Executed methods", this.executedMethods);
        acceptableDeviations.put("Biggest deviation in 30 day TGA trend", this.tgaTrend);
        return acceptableDeviations;
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String validationResult = this.getAcceptableDeviations().entrySet().stream().filter(entry -> (Double)entry.getValue() < 0.0).map(entry -> String.format("Acceptable deviation of %s must be greater than or equal 0.", entry.getKey())).collect(Collectors.joining("\n"));
        return StringUtils.isEmpty((String)validationResult) ? null : validationResult;
    }
}

