/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.index.check.CheckContext;
import com.teamscale.index.check.CheckOptionStore;
import com.teamscale.index.check.CheckPhaseResultDependencyIndex;
import com.teamscale.index.check.CheckPhaseResultIndex;
import com.teamscale.index.check.CheckProcessorBase;
import com.teamscale.index.check.CheckResultInvalidationIndex;
import com.teamscale.index.check.InvertedCheckPhaseResultIndex;
import com.teamscale.index.check.TokenElementContext;
import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.index.metadata.TokenElementMetadataIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.CheckInstance;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CheckProcessor
extends CheckProcessorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex schemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CheckPhaseResultIndex resultIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private InvertedCheckPhaseResultIndex invertedResultIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CheckPhaseResultDependencyIndex phaseResultDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementMetadataIndex tokenElementMetadataIndex;
    @DeltaSource(value=TokenElementMetadataIndex.class, indexName="token-elements-metadata")
    protected KeyDelta metadataDelta;
    private static final String CHECK_FINDING_PARTITION = "checks";
    public static final String ENABLED_CHECKS_PARAMETER = "enabled-checks.identifier";
    public static final String OPTIONS_PARAMETER = "options.value";
    @StepParameter(value="enabled-checks.identifier", optional=true)
    private final CodeScopeAware<List<String>> enabledChecks = CodeScopeAware.empty();
    @StepParameter(value="options.value")
    private CodeScopeAware<String> options;
    @DeltaSource(value=CheckResultInvalidationIndex.class)
    private KeyDelta additionalInvalidationDeltaFromCheckPhases;
    private final ThreadLocal<CodeScopeAware<ChecksAndContext>> checksAndContextPerThread = new ThreadLocal();

    public void execute() throws StorageException, ExecutionException {
        EnumSet<ECheckParameter> parameters = this.collectParametersOfEnabledChecks();
        Set<String> pathsToProcess = this.determineTokenElementsToAnalyze(parameters);
        this.executeInParallelBatches(pathsToProcess.stream().toList(), this::processBatch);
        List<String> filesDeletedFromContentIndex = this.determineDeletedElements();
        this.findingsIndex.removeFindingsForPartitionsAndPaths(CHECK_FINDING_PARTITION, filesDeletedFromContentIndex);
        this.phaseResultDependencyIndex.removeDependenciesOfFiles(this.contentDelta.getDeletedKeysAsStrings());
    }

    @Override
    protected Set<String> determineTokenElementsToAnalyze(EnumSet<ECheckParameter> parameters) throws StorageException {
        Set<String> tokenElementsToAnalyze = super.determineTokenElementsToAnalyze(parameters);
        tokenElementsToAnalyze.addAll(this.additionalInvalidationDeltaFromCheckPhases.getAddedOrChangedKeysAsStrings());
        List<String> filesWhoseMetadataChanged = this.tokenElementMetadataIndex.unabbreviateKeys((List<StorageKey>)this.metadataDelta.getAddedOrChangedKeys());
        tokenElementsToAnalyze.addAll(filesWhoseMetadataChanged);
        List<String> filesWhoseMetadataWasDeleted = this.tokenElementMetadataIndex.unabbreviateKeys((List<StorageKey>)this.metadataDelta.getDeletedKeys());
        filesWhoseMetadataWasDeleted.removeAll(this.contentDelta.getDeletedKeysAsStrings());
        tokenElementsToAnalyze.addAll(filesWhoseMetadataWasDeleted);
        return tokenElementsToAnalyze;
    }

    private @NonNull EnumSet<ECheckParameter> collectParametersOfEnabledChecks() {
        EnumSet<ECheckParameter> parameters = EnumSet.noneOf(ECheckParameter.class);
        for (CodeScopeName codeScopeName : this.enabledChecks.getCodeScopeNames()) {
            for (String checkName : (List)this.enabledChecks.getValue(codeScopeName)) {
                parameters.addAll(CheckRegistry.getInstance().getCheckInfo(checkName).getParameters());
            }
        }
        return parameters;
    }

    private void processBatch(List<String> processedPaths) throws StorageException {
        Optional<CodeScopeAware<ChecksAndContext>> checksAndContext = this.ensureChecksAndContextInitialized();
        if (checksAndContext.isEmpty()) {
            return;
        }
        List<TokenElementInfo> elements = this.getTokenElementInfos(processedPaths);
        List<List<IFileMetadata>> metadata = this.tokenElementMetadataIndex.getMetadataForFiles(processedPaths);
        HashMap<String, CodeScopeName> uniformPathToCodeScopeMapping = new HashMap<String, CodeScopeName>();
        for (int i = 0; i < elements.size(); ++i) {
            TokenElementInfo tokenElementInfo = elements.get(i);
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElementInfo);
            uniformPathToCodeScopeMapping.put(tokenElementInfo.getUniformPath(), codeScopeName);
            if (tokenElementInfo.isFilteredCompletely() || !CheckProcessor.elementIsHandledByCheckFramework(tokenElementInfo)) continue;
            this.analyzeElement(tokenElementInfo, metadata.get(i), (ChecksAndContext)checksAndContext.get().getValue(codeScopeName));
        }
        ListMap pathToFindingsMapping = new ListMap();
        for (CodeScopeName codeScopeName : this.enabledChecks.getCodeScopeNames()) {
            ListMap<String, IndexFinding> uniformPathToFindings = ((ChecksAndContext)checksAndContext.get().getValue((CodeScopeName)codeScopeName)).context.getUniformPathToFindings();
            pathToFindingsMapping.addAll(uniformPathToFindings);
        }
        this.updateFindingsInIndex(processedPaths, (ListMap<String, IndexFinding>)pathToFindingsMapping, uniformPathToCodeScopeMapping);
    }

    private List<TokenElementInfo> getTokenElementInfos(List<String> processedPaths) throws StorageException {
        List elements = this.contentIndex.getTokenElements(processedPaths);
        List nullIndices = CollectionUtils.getNullIndices(elements);
        if (!nullIndices.isEmpty()) {
            ArrayList unknownPaths = CollectionUtils.getIndices(processedPaths, (List)nullIndices);
            LOGGER.error("Skipping non-existing files: {}", (Object)StringUtils.concat((Iterable)unknownPaths, (String)", "));
            elements = CollectionUtils.returnListWithoutGivenIndices(elements, new HashSet(nullIndices));
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CodeScopeAware<ChecksAndContext>> ensureChecksAndContextInitialized() {
        CodeScopeAware scopedChecksAndContext = this.checksAndContextPerThread.get();
        if (scopedChecksAndContext != null) {
            return Optional.of(scopedChecksAndContext);
        }
        this.getProfilingMonitor().startProfiling("Initialization");
        try {
            scopedChecksAndContext = CodeScopeAware.empty();
            for (CodeScopeName codeScopeName : this.enabledChecks.getCodeScopeNames()) {
                CheckRegistry checkRegistry = CheckRegistry.getInstance();
                CheckOptionStore optionStore = CheckOptionStore.deserializeFromBase64String((String)this.options.getValue(codeScopeName));
                CheckContext context = new CheckContext(this.resultIndex, this.invertedResultIndex);
                List<CheckInstance> checks = ((List)this.enabledChecks.getValue(codeScopeName)).stream().map(checkId -> CheckProcessor.instantiateAndInitializeCheck(checkRegistry, optionStore, context, checkId)).filter(Objects::nonNull).toList();
                scopedChecksAndContext.setValue(codeScopeName, (Object)new ChecksAndContext(checks, context));
            }
            this.checksAndContextPerThread.set((CodeScopeAware<ChecksAndContext>)scopedChecksAndContext);
            Optional<CodeScopeAware> optional = Optional.of(scopedChecksAndContext);
            return optional;
        }
        finally {
            this.getProfilingMonitor().stopProfiling("Initialization");
        }
    }

    private static CheckInstance instantiateAndInitializeCheck(CheckRegistry checkRegistry, CheckOptionStore optionStore, CheckContext context, String checkIdentifier) {
        try {
            CheckInstance checkInstance = checkRegistry.instantiateCheck(checkIdentifier);
            optionStore.applyCheckOptions(checkInstance);
            checkInstance.initializeAndSetContext((ICheckContext)context);
            return checkInstance;
        }
        catch (CheckException e) {
            LOGGER.error("Could not initialize check '{}': {}", (Object)checkIdentifier, (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private void updateFindingsInIndex(List<String> processedPaths, ListMap<String, IndexFinding> pathToFindingsMapping, Map<String, CodeScopeName> uniformPathToCodeScopeMapping) throws StorageException {
        PairList findingsList = new PairList();
        for (String path : processedPaths) {
            List findingsForPath = (List)pathToFindingsMapping.getCollection((Object)path);
            if (findingsForPath == null) {
                findingsForPath = CollectionUtils.emptyList();
            }
            findingsList.add((Object)path, new ArrayList(findingsForPath));
        }
        CodeScopeAware codeScopeToFindingsSchemaMapping = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : this.enabledChecks.getCodeScopeNames()) {
            codeScopeToFindingsSchemaMapping.setValue(codeScopeName, (Object)this.schemaIndex.getFindingsSchema(codeScopeName));
        }
        this.findingsIndex.setFindings(CHECK_FINDING_PARTITION, findingsList, codeScopeToFindingsSchemaMapping, uniformPathToCodeScopeMapping);
    }

    private void analyzeElement(TokenElementInfo element, List<IFileMetadata> metadata, ChecksAndContext checksAndContext) throws StorageException {
        try (CheckContext context = checksAndContext.context();){
            context.reset(element);
            context.setFileMetadata(metadata);
            for (CheckInstance check : checksAndContext.checks()) {
                if (!CheckProcessor.shouldRunCheckOnElement(element, context, check)) continue;
                this.getProfilingMonitor().startProfiling(check.getCheckInfo().getCheckClassName());
                if (!this.runCheckOnElement(element, check, context)) continue;
                this.getProfilingMonitor().stopProfiling(check.getCheckInfo().getCheckClassName());
            }
            context.persistAndResetPhaseQueryInformation(this.phaseResultDependencyIndex);
        }
    }

    private static boolean shouldRunCheckOnElement(TokenElementInfo element, CheckContext context, CheckInstance check) {
        if (!check.getCheckInfo().getSupportedLanguages().contains(element.getLanguage())) {
            return false;
        }
        if (check.getCheckInfo().getTargets().size() == ECheckTarget.values().length) {
            return true;
        }
        if (context.isTestCode()) {
            return check.getCheckInfo().getTargets().contains(ECheckTarget.TEST_CODE);
        }
        return check.getCheckInfo().getTargets().contains(ECheckTarget.PRODUCTION_CODE);
    }

    private boolean runCheckOnElement(TokenElementInfo element, CheckInstance check, CheckContext context) {
        try {
            this.prepareContext(context, check);
            if (!CheckProcessor.checkContextIsPrepared(check, context, element)) {
                return false;
            }
            check.execute();
        }
        catch (CheckException e) {
            LOGGER.error("Error executing custom check '{}' on '{}'. Skipping check.", (Object)check.getCheckInfo().getId(), (Object)element, (Object)e);
        }
        catch (Throwable e) {
            LOGGER.error("Critical error executing custom check '{}' on '{}'. Skipping check.", (Object)check.getCheckInfo().getId(), (Object)element, (Object)e);
        }
        return true;
    }

    private static boolean checkContextIsPrepared(CheckInstance check, CheckContext context, TokenElementInfo element) {
        if (!EFeatureToggle.DISABLE_CLANG_JNI_CHECKS.isEnabled() && CheckProcessor.clangParserInitializationFailed(check.getCheckInfo().getParameters(), context)) {
            LOGGER.warn("Skipping custom check '{}' on '{}' because clang parser could not be initialized.", (Object)check.getCheckInfo().getId(), (Object)element);
            return false;
        }
        return true;
    }

    private void prepareContext(CheckContext context, CheckInstance executedCheck) throws ConQATException {
        CheckInfo checkInfo = executedCheck.getCheckInfo();
        Set parameters = checkInfo.getParameters();
        context.setCheckInfo(checkInfo);
        this.prepareContext((TokenElementContext)context, parameters);
    }

    private record ChecksAndContext(Collection<CheckInstance> checks, CheckContext context) {
    }
}

