/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.report.parser.ClangReportParser;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Set;

public class ClangConfiguration
extends ToolConfigurationBase {
    public static final String CATEGORY_NAME = "Clang";

    public ClangConfiguration() {
        super(EAnalysisTool.CLANG, CATEGORY_NAME, CATEGORY_NAME);
        this.declareCodeScopeAware();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        for (String clangCategory : ClangReportParser.getClangCategoryNames()) {
            FindingDescriptor finding = new FindingDescriptor(clangCategory, EAnalysisTool.CLANG, (Set)LanguageGroups.C_CPP_AND_MS_CLI, EFindingEnablement.RED, clangCategory + " checks performed by Clang static analyzer.");
            this.registerFinding(finding, this.getGroup("Static analysis"), clangCategory, template.getCodeScope());
        }
        super.registerQualityIndicators(template, languages, tools);
    }
}

