/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.configuration.tools.NodeJsLinterUtils;
import com.teamscale.index.findings.eslint.ESLintFindingsSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.util.Set;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.string.StringUtils;

public class ESLintConfiguration
extends ToolConfigurationBase {
    public static final String ES_LINT_FINDING_CATEGORY = "ESLint";
    private static final String DESCRIPTIONS_PATH = "eslint";
    private static final String ESLINT_MAPPINGS_TSV = "eslint/check-mappings.tsv";
    public static final String ESLINT_SETTINGS_FILE_OPTION_NAME = "ESLint settings file";
    @ConfigExposed(name="ESLint settings file", description="Path to a custom ESLint settings file. For security reasons, only files from Teamscale's config directory are allowed. Path can be absolute or relative to the working directory.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public CodeScopeAware<String> settingsFile = CodeScopeAware.defaultCodeScopeWithValue((Object)"");

    public ESLintConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.ESLINT, ES_LINT_FINDING_CATEGORY, DESCRIPTIONS_PATH, ESLINT_MAPPINGS_TSV, "");
        this.declareCodeScopeAware();
    }

    protected String getDescriptionFileName(String ruleId) {
        if (ruleId.startsWith("react/")) {
            return super.getDescriptionFileName("eslint-plugin-react/" + StringUtils.stripPrefix((String)ruleId, (String)"react/"));
        }
        if (ruleId.startsWith("@typescript-eslint/") || ruleId.startsWith("@angular-eslint/")) {
            return super.getDescriptionFileName(ruleId);
        }
        if (ruleId.startsWith("jsx-a11y/")) {
            return super.getDescriptionFileName("eslint-plugin-jsx-a11y/" + StringUtils.stripPrefix((String)ruleId, (String)"jsx-a11y/"));
        }
        if (ruleId.startsWith("security/")) {
            return super.getDescriptionFileName("eslint-plugin-security/" + StringUtils.stripPrefix((String)ruleId, (String)"security/"));
        }
        return super.getDescriptionFileName("eslint/" + ruleId);
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        TriggerBuilder triggerBuilder = new TriggerBuilder(ESLintFindingsSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setCost(ETriggerCost.EXPENSIVE);
        triggerBuilder.setTriggerParameter("active-finding-group-names", (ITriggerParameter)activeChecksPerCodeScope);
        for (CodeScopeName codeScopeName : this.settingsFile.getCodeScopeNames()) {
            String settingsFileForCodeScope = (String)this.settingsFile.getValueWithDefault(codeScopeName);
            if (StringUtils.isEmpty((String)settingsFileForCodeScope) || new File(settingsFileForCodeScope).exists()) continue;
            throw new ProjectConfigurationException("Specified settings file could not be found: " + settingsFileForCodeScope);
        }
        triggerBuilder.setTriggerParameter("settings-file", this.settingsFile);
        ESLintConfiguration.checkNativeZipPresence();
        proxy.createTrigger(triggerBuilder);
        super.configureProjectInternal(proxy);
    }

    public void validateTools() throws ProjectConfigurationException {
        NodeJsLinterUtils.getNodeJSFromSystem();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        if (!tools.contains(EAnalysisTool.ESLINT)) {
            return;
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("settingsFile", template.getCodeScope()));
    }

    private static void checkNativeZipPresence() throws ProjectConfigurationException {
        File nativeLib = ESLintConfiguration.getEslintDirectory();
        if (!nativeLib.exists()) {
            throw new ProjectConfigurationException("Bundled ESLint installation was not found in path: " + nativeLib.getAbsolutePath());
        }
    }

    public static File getEslintDirectory() {
        return NativeLibUtil.getNativeLib((String)DESCRIPTIONS_PATH);
    }
}

