/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.abap;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules.AbapRuleUtils;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityOrMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class AbapShallowEntityMatcher
implements IShallowEntityMatcher {
    private static final TokenPattern AND_RETURN_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.AND, ETokenType.RETURN}).optional(new Object[]{ETokenType.DOT}).endOfStream();
    public static final IShallowEntityMatcher SIMPLE_STATEMENT_MATCHER = new IShallowEntityMatcher(){

        @Override
        public boolean matches(ShallowEntity entity) {
            return this.isSimpleStatement(entity) || this.isVariableDeclaration(entity);
        }

        private boolean isVariableDeclaration(ShallowEntity entity) {
            return AbapRuleUtils.hasSubtype(entity, "data", "class-data", "statics", "constants", "field-symbols", "parameters", "tables", "nodes", "ranges", "select-options", "field-groups");
        }

        private boolean isSimpleStatement(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.STATEMENT && entity.getChildren().isEmpty();
        }

        public String toString() {
            return "ABAP_SIMPLE_STATEMENT_MATCHER";
        }
    };
    public static final IShallowEntityMatcher WHEN_OTHERS_MATCHER = new IShallowEntityMatcher(){

        @Override
        public boolean matches(ShallowEntity entity) {
            if (!AbapRuleUtils.hasSubtype(entity, "when")) {
                return false;
            }
            return ((IToken)entity.ownStartTokens().get(1)).getType() == ETokenType.OTHERS;
        }

        public String toString() {
            return "WHEN_OTHERS_MATCHER";
        }
    };
    private static final IShallowEntityMatcher SUBMIT_WITHOUT_RETURN = new IShallowEntityMatcher(){

        @Override
        public boolean matches(ShallowEntity entity) {
            UnmodifiableList tokens = entity.ownStartTokens();
            if (!AbapRuleUtils.hasSubtype(entity, "submit")) {
                return false;
            }
            return !AND_RETURN_PATTERN.matchesAnywhere((List)tokens);
        }

        public String toString() {
            return "SUBMIT_WITHOUT_RETURN";
        }
    };
    public static final IShallowEntityMatcher RETURN_MATCHER = new ShallowEntityOrMatcher(new AbapShallowEntityMatcher("leave"), new AbapShallowEntityMatcher("return"), new AbapShallowEntityMatcher("stop"), new AbapShallowEntityMatcher("reject"), new AbapShallowEntityMatcher("raise"), SUBMIT_WITHOUT_RETURN);
    public static final IShallowEntityMatcher UNINTERESTING_ENTITIES = new ShallowEntityOrMatcher(new AbapShallowEntityMatcher("types"), new AbapShallowEntityMatcher("nodes"), new AbapShallowEntityMatcher("tables"), new AbapShallowEntityMatcher("include"), new AbapShallowEntityMatcher("type-pools"), new AbapShallowEntityMatcher("macro"), new AbapShallowEntityMatcher("CLASS-EVENTS"), new AbapShallowEntityMatcher("EVENTS"), new AbapShallowEntityMatcher("INFOTYPES"));
    public static final IShallowEntityMatcher TRANSPARENT_ENTITIES = new ShallowEntityOrMatcher(new AbapShallowEntityMatcher("ENHANCEMENT-SECTION"), new AbapShallowEntityMatcher("on change"));
    private final String subtype;
    private final TokenPattern tokenPattern;

    public AbapShallowEntityMatcher(String subtype) {
        this.subtype = subtype;
        this.tokenPattern = null;
    }

    public AbapShallowEntityMatcher(String subtype, TokenPattern tokenPattern) {
        this.subtype = subtype;
        this.tokenPattern = tokenPattern;
    }

    @Override
    public boolean matches(ShallowEntity entity) {
        boolean subTypeMatches;
        boolean bl = subTypeMatches = this.subtype.equalsIgnoreCase(entity.getSubtype()) || (this.subtype + ":").equalsIgnoreCase(entity.getSubtype());
        if (this.tokenPattern == null || !subTypeMatches) {
            return subTypeMatches;
        }
        return this.tokenPattern.matchesAnywhere((List)entity.ownStartTokens());
    }

    public String toString() {
        return "AbapShallowEntityMatcher (" + this.subtype + ")";
    }
}

