/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp;

import com.teamscale.index.dataflow.controlflowgraph.VariableDereferenceInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DefUseHeuristicUtils;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeSelfModificationExpressionPattern;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CDataflowUtils;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.IdentifierVisibilityScopeStack;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStreamParser;
import eu.cqse.check.framework.util.tokens.TokenStreamSplitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class CppDefUseHeuristic
implements IDefUseHeuristic {
    private static final EnumSet<ETokenType> TYPE_MODIFIERS = EnumSet.of(ETokenType.CONST, new ETokenType[]{ETokenType.SIGNED, ETokenType.UNSIGNED, ETokenType.MULT, ETokenType.AND, ETokenType.ANDAND, ETokenType.STRUCT, ETokenType.ELLIPSIS, ETokenType.XOR, ETokenType.MOD, ETokenType.TYPENAME});
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EnumSet<ETokenType> PRIMITIVE_NUMERIC_TYPES = EnumSet.of(ETokenType.LONG, ETokenType.CHAR, ETokenType.INT, ETokenType.SHORT, ETokenType.DOUBLE);
    private static final ETokenType ASSIGNMENT_OPERATOR = ETokenType.EQ;
    private static final EnumSet<ETokenType> MODIFICATION_OPERATOR_SET = EnumSet.of(ETokenType.PLUSEQ, new ETokenType[]{ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.URSHIFTEQ});
    private static final EnumSet<ETokenType> TWO_SIDED_ASSIGNMENT_OPERATOR_SET = EnumUtils.mergeSets(MODIFICATION_OPERATOR_SET, (Enum[])new ETokenType[]{ASSIGNMENT_OPERATOR});
    private static final EnumSet<ETokenType> CPP_ALTERNATIVE_OPERATORS = EnumSet.of(ETokenType.NOT, new ETokenType[]{ETokenType.COMP, ETokenType.NOTEQ, ETokenType.ANDAND, ETokenType.OROR, ETokenType.AND, ETokenType.OR, ETokenType.XOR, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ});
    private final EnumSet<ETokenType> typeModifiers = TYPE_MODIFIERS;
    private final IdentifierVisibilityScopeStack identifierVisibilityScopeStack = new IdentifierVisibilityScopeStack();

    private static boolean identifierIsInParameterListOfSizeofOperator(List<IToken> tokens, Integer identifierIndex) {
        int currentIndex = identifierIndex;
        while (currentIndex > 0) {
            if (tokens.get(--currentIndex).getType() == ETokenType.RPAREN) {
                return false;
            }
            if (!TokenStreamTextUtils.hasSequence(tokens, (int)currentIndex, (String[])new String[]{"sizeof", "("})) continue;
            return true;
        }
        return false;
    }

    private static boolean identifierIsInSizeOfExpression(List<IToken> tokens, Integer identifierIndex) {
        int currentIndex = identifierIndex;
        while (currentIndex > 0) {
            TokenPattern expressionMatcher = new TokenPattern().sequence(new Object[]{ETokenType.SIZEOF, ETokenType.IDENTIFIER});
            TokenPatternMatch match = expressionMatcher.findFirstMatch(tokens.subList(--currentIndex, tokens.size()));
            if (match == null) continue;
            return true;
        }
        return false;
    }

    private static boolean skipCppStructMembers(TokenStreamParser parser) {
        if (parser.isAnyOf(EnumSet.of(ETokenType.LBRACE))) {
            return (Boolean)parser.skipBalanced(ETokenType.LBRACE, ETokenType.RBRACE, EnumSet.complementOf(EnumSet.of(ETokenType.LBRACE, ETokenType.RBRACE))).getFirst();
        }
        return true;
    }

    private static boolean hasValidArrayNotation(TokenStreamParser parser) {
        while (parser.isAnyOf(EnumSet.of(ETokenType.LBRACK))) {
            parser.consumeOneOrZeroOf(ETokenType.LBRACK);
            parser.consumeAnyOf((ITokenMatcher)ETokenType.COMMA);
            if (!parser.consumeOneOrZeroOf(ETokenType.RBRACK).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public VariableReadWriteInfo parseParameterList(List<IToken> parameterListTokens, ShallowEntity functionEntity) {
        if (parameterListTokens.size() == 1 && parameterListTokens.get(0).getType() == ETokenType.VOID) {
            return new VariableReadWriteInfo();
        }
        boolean mustContainTypes = !"lambda expression".equals(functionEntity.getSubtype()) && !"block expression".equals(functionEntity.getSubtype()) && !CppDefUseHeuristic.looksLikeKandRFunctionDefinition(functionEntity);
        VariableReadWriteInfo info = new VariableReadWriteInfo();
        TokenStreamParser parser = new TokenStreamParser(parameterListTokens, EnumSet.of(ETokenType.PREPROCESSOR_DIRECTIVE));
        while (!parser.isDone()) {
            if (CppDefUseHeuristic.consumeEllipsisTokenInParameterList(parser)) continue;
            Optional<VariableWrite> extractedParameterInfo = this.parseParameter(parser, functionEntity, mustContainTypes);
            extractedParameterInfo.ifPresent(variableWrite -> info.getDefinitions().add((VariableWrite)variableWrite));
            DefUseHeuristicUtils.skipToNextCommaOrEnd(parser);
        }
        return info;
    }

    private static boolean consumeEllipsisTokenInParameterList(TokenStreamParser parser) {
        return !parser.consumeAnyOf((ITokenMatcher)ETokenType.ELLIPSIS).isEmpty();
    }

    private VariableDereferenceInfo parseDereferences(List<IToken> tokens) {
        boolean isDefinitionStatement;
        VariableDereferenceInfo dereferenceInfo = new VariableDereferenceInfo();
        LanguageFeatureParser.CPP.computePlainPointerDereference(tokens, dereferenceInfo::addDereference);
        dereferenceInfo.merge(CppDefUseHeuristic.getDereferencesFromMemberAccesses(tokens));
        int sizeOfLeadingType = this.getSizeOfLeadingType(tokens);
        boolean bl = isDefinitionStatement = sizeOfLeadingType > 0;
        if (!isDefinitionStatement) {
            dereferenceInfo.merge(this.getDereferencesFromFunctionCalls(tokens));
        }
        return dereferenceInfo;
    }

    private VariableDereferenceInfo getDereferencesFromFunctionCalls(List<IToken> tokens) {
        VariableDereferenceInfo dereferenceInfo = new VariableDereferenceInfo();
        Iterator iterator = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.LPAREN}).iterator();
        while (iterator.hasNext()) {
            int lParenIndex = (Integer)iterator.next();
            if (lParenIndex <= 0 || ETokenType.IDENTIFIER != tokens.get(lParenIndex - 1).getType()) continue;
            IToken functionCallToken = tokens.get(lParenIndex - 1);
            String functionName = functionCallToken.getText();
            if (lParenIndex - 2 > 0 && EnumSet.of(ETokenType.POINTERTO, ETokenType.DOT, ETokenType.SCOPE).contains(tokens.get(lParenIndex - 2).getType()) || !this.isKnownVariableName(functionName)) continue;
            dereferenceInfo.addDereference(functionName, functionCallToken.getOffset());
        }
        return dereferenceInfo;
    }

    private static VariableDereferenceInfo getDereferencesFromMemberAccesses(List<IToken> tokens) {
        VariableDereferenceInfo dereferenceInfo = new VariableDereferenceInfo();
        Iterator iterator = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.POINTERTO}).iterator();
        while (iterator.hasNext()) {
            int arrowIndex = (Integer)iterator.next();
            int identifierIndex = arrowIndex - 1;
            if (identifierIndex < 0 || ETokenType.IDENTIFIER != tokens.get(identifierIndex).getType() || CppDefUseHeuristic.isPreceededByPointerToOrDot(tokens, identifierIndex) || CppDefUseHeuristic.identifierIsInParameterListOfSizeofOperator(tokens, identifierIndex) || CppDefUseHeuristic.identifierIsInSizeOfExpression(tokens, identifierIndex)) continue;
            IToken dereferencedVariableToken = tokens.get(identifierIndex);
            dereferenceInfo.addDereference(dereferencedVariableToken.getText(), dereferencedVariableToken.getOffset());
        }
        return dereferenceInfo;
    }

    private static boolean isPreceededByPointerToOrDot(List<IToken> tokens, int tokenIndex) {
        int preceedingTokenIndex = tokenIndex - 1;
        if (preceedingTokenIndex < 0) {
            return false;
        }
        ETokenType tokenType = tokens.get(preceedingTokenIndex).getType();
        return tokenType == ETokenType.POINTERTO || tokenType == ETokenType.DOT;
    }

    private static int skipAnnotations(TokenStreamParser parser) {
        int count = 0;
        while (!parser.isDone() && parser.continuesWithSequence(new ETokenType[]{ETokenType.LBRACK, ETokenType.LBRACK})) {
            ++count;
            parser.skipToSequence(new ETokenType[]{ETokenType.RBRACK, ETokenType.RBRACK});
            if (!parser.consumeOneOrZeroOf(ETokenType.RBRACK).isEmpty() && !parser.consumeOneOrZeroOf(ETokenType.RBRACK).isEmpty()) continue;
            return -1;
        }
        return count;
    }

    private static String skipAndReturnBaseType(TokenStreamParser parser) {
        CppDefUseHeuristic.skipParameterAttributes(parser);
        List primitiveType = parser.consumeAnyOf(CppShallowParser.TYPES_TOKENS);
        if (!primitiveType.isEmpty()) {
            CppDefUseHeuristic.skipAttributesInParameterDeclaration(parser);
            return TokenStreamTextUtils.concatTokenTexts((List)primitiveType, (String)" ");
        }
        ArrayList baseTypeParts = new ArrayList();
        parser.consumeOneOrZeroOf(ETokenType.SCOPE).ifPresent(baseTypeParts::add);
        if (parser.isAnyOf(EnumSet.of(ETokenType.IDENTIFIER))) {
            parser.consumeOneOrZeroOf(ETokenType.IDENTIFIER).ifPresent(baseTypeParts::add);
            int consumedTokensBeforeIteration = -1;
            while (!parser.isAnyOf(EnumSet.of(ETokenType.IDENTIFIER)) && !parser.isDone() && consumedTokensBeforeIteration < parser.getConsumedTokenCount()) {
                consumedTokensBeforeIteration = parser.getConsumedTokenCount();
                Pair templateArguments = parser.skipBalanced(ETokenType.LT, ETokenType.GT, EnumSet.complementOf(EnumSet.of(ETokenType.LT, ETokenType.GT)));
                baseTypeParts.addAll((Collection)templateArguments.getSecond());
                baseTypeParts.addAll(parser.consumeAlternating(EnumSet.of(ETokenType.SCOPE), EnumSet.of(ETokenType.IDENTIFIER)));
                baseTypeParts.addAll(parser.consumeAnyOf(EnumSet.of(ETokenType.AND, ETokenType.MULT)));
            }
        } else {
            baseTypeParts.addAll(parser.consumeAnyOf(EnumSet.of(ETokenType.AND, ETokenType.MULT)));
        }
        CppDefUseHeuristic.skipAttributesInParameterDeclaration(parser);
        return TokenStreamTextUtils.concatTokenTexts(baseTypeParts, (String)" ");
    }

    private static void skipParameterAttributes(TokenStreamParser parser) {
        if (parser.isDone() || !parser.currentText().startsWith("[")) {
            return;
        }
        parser.consumeOneOrZeroOf(ETokenType.LBRACK);
        if (parser.skipToFirstTopLevel(Set.of(ETokenType.RBRACK), (List)TokenStreamUtils.STANDARD_OPENING_TOKEN_TYPES, (List)TokenStreamUtils.STANDARD_CLOSING_TOKEN_TYPES)) {
            parser.consumeOneOrZeroOf(ETokenType.RBRACK);
        } else {
            LOGGER.warn(SourceCodeMessageUtils.createMessage((String)"Data flow analysis could not find closing ] of attribute in parameter list", (List)parser.getTokens(), null));
        }
    }

    private static void skipAttributesInParameterDeclaration(TokenStreamParser parser) {
        if (parser.isDone()) {
            return;
        }
        if (parser.currentText().startsWith("__") && parser.currentType() == ETokenType.IDENTIFIER) {
            parser.consumeAnyOf((ITokenMatcher)ETokenType.IDENTIFIER);
        }
    }

    private int getSizeOfLeadingType(List<IToken> tokens) {
        if (this.isKnownVariableName(tokens.get(0).getText())) {
            return 0;
        }
        int sizeOfLeadingType = 0;
        TokenStreamParser parser = new TokenStreamParser(tokens);
        if (CppDefUseHeuristic.skipAnnotations(parser) != -1 && this.skipType(parser, null) != null && parser.isAnyOf(EnumSet.of(ETokenType.IDENTIFIER))) {
            sizeOfLeadingType = parser.getConsumedTokenCount();
        }
        if (sizeOfLeadingType > 0 && tokens.get(sizeOfLeadingType - 1).getType() == ETokenType.MULT) {
            --sizeOfLeadingType;
        }
        return sizeOfLeadingType;
    }

    private static boolean isNullPointerAssignment(List<IToken> leftSideOfAssignment, List<IToken> rightSideOfAssignment) {
        if (rightSideOfAssignment.size() == 1) {
            IToken rightSideToken = rightSideOfAssignment.get(0);
            if ("0".equals(rightSideToken.getText())) {
                return TokenStreamUtils.startsWith(leftSideOfAssignment, (ETokenType[])new ETokenType[]{ETokenType.MULT});
            }
            return CDataflowUtils.NULL_VALUE_PATTERN.matchAtStartOf(rightSideOfAssignment) != null;
        }
        return false;
    }

    private static Optional<Pair<Optional<IToken>, String>> tryCppSpecificParameterCorrections(TokenStreamParser parser) {
        Optional correction = parser.tryConsume(CppDefUseHeuristic::functionPointerParameterConsumer);
        if (correction.isPresent()) {
            return correction;
        }
        return parser.tryConsume(CppDefUseHeuristic::clangBlockTypeParameterConsumer);
    }

    private static Pair<Optional<IToken>, String> parseFunctionPointerNameAndType(TokenStreamParser parser) {
        List typeTokens = parser.consumeAlternating(EnumSet.of(ETokenType.IDENTIFIER), EnumSet.of(ETokenType.SCOPE));
        parser.skipBalanced(ETokenType.LT, ETokenType.SCOPE, EnumSet.of(ETokenType.IDENTIFIER, ETokenType.GT));
        ArrayList consumedFunctionTokens = new ArrayList(parser.consumeAnyOf(EnumSet.of(ETokenType.MULT, ETokenType.AND)));
        String typeExtension = "( " + TokenStreamTextUtils.concatTokenTexts(consumedFunctionTokens, (String)" ");
        parser.skipBalanced(ETokenType.LBRACK, ETokenType.RBRACK, EnumSet.complementOf(EnumSet.of(ETokenType.LBRACK, ETokenType.RBRACK)));
        parser.consumeAnyOf(EnumSet.of(ETokenType.CONST, ETokenType.VOLATILE));
        Optional<IToken> identifier = parser.consumeOneOrZeroOf(EnumSet.of(ETokenType.IDENTIFIER));
        if (identifier.isEmpty() && typeTokens.size() == 1) {
            identifier = Optional.of((IToken)typeTokens.get(0));
            typeTokens.clear();
        }
        if (!((List)parser.skipBalanced(ETokenType.LBRACK, ETokenType.RBRACK, EnumSet.complementOf(EnumSet.of(ETokenType.LBRACK, ETokenType.RBRACK))).getSecond()).isEmpty()) {
            typeExtension = typeExtension + "[ ]";
        }
        typeExtension = typeExtension + " ) ";
        return Pair.createPair(identifier, (Object)typeExtension);
    }

    private static Optional<Pair<Optional<IToken>, String>> functionPointerParameterConsumer(TokenStreamParser parser) {
        List leftParens = parser.consumeAnyOf((ITokenMatcher)ETokenType.LPAREN);
        if (leftParens.isEmpty()) {
            return Optional.empty();
        }
        Pair<Optional<IToken>, String> functionPointerNameAndType = CppDefUseHeuristic.parseFunctionPointerNameAndType(parser);
        if (parser.consumeOneOrZeroOf(EnumSet.of(ETokenType.RPAREN)).isEmpty()) {
            return Optional.empty();
        }
        Pair skippedFunctionPointerParameters = parser.skipBalanced(ETokenType.LPAREN, ETokenType.RPAREN, EnumSet.complementOf(EnumSet.of(ETokenType.LPAREN, ETokenType.RPAREN)));
        int openParenthesesCount = leftParens.size() - 1;
        if (parser.consumeAnyOf((ITokenMatcher)ETokenType.RPAREN).size() != openParenthesesCount) {
            return Optional.empty();
        }
        Object typeExtension = (String)functionPointerNameAndType.getSecond();
        typeExtension = (String)typeExtension + TokenStreamTextUtils.concatTokenTexts((List)((List)skippedFunctionPointerParameters.getSecond()), (String)" ");
        return Optional.of(Pair.createPair((Object)((Optional)functionPointerNameAndType.getFirst()), (Object)typeExtension));
    }

    private static Optional<Pair<Optional<IToken>, String>> clangBlockTypeParameterConsumer(TokenStreamParser parser) {
        if (parser.consumeOneOrZeroOf(ETokenType.LPAREN).isEmpty() || parser.consumeOneOrZeroOf(ETokenType.XOR).isEmpty()) {
            return Optional.empty();
        }
        Optional identifier = parser.consumeOneOrZeroOf(ETokenType.IDENTIFIER);
        if (parser.consumeOneOrZeroOf(ETokenType.RPAREN).isEmpty()) {
            return Optional.empty();
        }
        Pair parameterList = parser.skipBalancedParentheses();
        if (!((Boolean)parameterList.getFirst()).booleanValue()) {
            return Optional.empty();
        }
        String typeExtension = "(^)(" + TokenStreamTextUtils.concatTokenTexts((List)((List)parameterList.getSecond()), (String)",") + ")";
        return Optional.of(Pair.createPair((Object)identifier, (Object)typeExtension));
    }

    private static Optional<Boolean> emptyTypenameParameterConsumer(TokenStreamParser parser) {
        if (parser.isDone() || parser.isAnyOf(EnumSet.of(ETokenType.COMMA))) {
            parser.consumeOneOrZeroOf(EnumSet.of(ETokenType.COMMA));
            return Optional.of(true);
        }
        if (parser.isAnyOf(EnumSet.of(ETokenType.EQ))) {
            parser.consumeAnyExcept(EnumSet.of(ETokenType.COMMA));
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private void modifyReadWriteInfoLanguageSpecific(List<IToken> tokens, VariableReadWriteInfo info) {
        for (String string : this.findVariablesWrittenViaCallByReference(tokens)) {
            VariableWrite write = new VariableWrite(string);
            info.getAssignments().add(write);
            info.getReads().add(string);
        }
    }

    private Collection<? extends String> findVariablesWrittenViaCallByReference(List<IToken> tokens) {
        HashSet<String> variablesPassedByReference = new HashSet<String>();
        int currentParameterListStart = 0;
        while (currentParameterListStart != -1 && (currentParameterListStart = TokenStreamUtils.findFirstTopLevelWithIndexPredicate(tokens, (int)currentParameterListStart, index -> TokenStreamUtils.hasTokenTypeSequence((List)tokens, (int)index, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}), Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN))) != -1) {
            int parameterListEnd = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(currentParameterListStart += 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (parameterListEnd == -1) continue;
            Iterator iterator = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)currentParameterListStart, (int)parameterListEnd, (ETokenType[])new ETokenType[]{ETokenType.AND, ETokenType.IDENTIFIER}).iterator();
            while (iterator.hasNext()) {
                String variableName;
                int paramIndex = (Integer)iterator.next();
                if (!EnumSet.of(ETokenType.COMMA, ETokenType.RPAREN).contains(tokens.get(paramIndex + 2).getType()) || !this.isKnownVariableName(variableName = tokens.get(paramIndex + 1).getText())) continue;
                variablesPassedByReference.add(variableName);
            }
        }
        return variablesPassedByReference;
    }

    private Optional<VariableWrite> parseParameter(TokenStreamParser parser, ShallowEntity methodEntity, boolean mustContainTypes) {
        int startIndexOfParameter = parser.getConsumedTokenCount();
        Object type = this.skipType(parser, methodEntity);
        if (parser.tryConsume(CppDefUseHeuristic::emptyTypenameParameterConsumer).isPresent()) {
            return Optional.empty();
        }
        Optional keyword = parser.consumeOneOrZeroOf(EnumSet.copyOf(ETokenType.KEYWORDS));
        EnumSet<ETokenType> possibleIdentifierTokens = EnumSet.of(ETokenType.IDENTIFIER);
        possibleIdentifierTokens.addAll(CPP_ALTERNATIVE_OPERATORS);
        Optional identifier = parser.consumeOneOrZeroOf(possibleIdentifierTokens);
        if (identifier.isEmpty()) {
            Optional<Pair<Optional<IToken>, String>> correction = CppDefUseHeuristic.tryCppSpecificParameterCorrections(parser);
            if (correction.isPresent() && ((Optional)correction.get().getFirst()).isPresent()) {
                identifier = (Optional)correction.get().getFirst();
                type = (String)type + (String)correction.get().getSecond();
            } else if (correction.isPresent()) {
                return Optional.empty();
            }
        }
        if (keyword.isPresent()) {
            return Optional.empty();
        }
        String type2 = type;
        return this.createParameter((String)type, identifier.orElse(null), mustContainTypes, () -> DefUseHeuristicUtils.createParameterListParsingErrorMessage(startIndexOfParameter, parser, type2, methodEntity));
    }

    @VisibleForTesting
    static boolean looksLikeKandRFunctionDefinition(ShallowEntity methodEntity) {
        UnmodifiableList startTokens = methodEntity.ownStartTokens();
        if (!TokenStreamUtils.endsWith((List)startTokens, (ETokenType[])new ETokenType[]{ETokenType.LBRACE})) {
            return false;
        }
        if (LanguageGroups.CPP_AND_OBJECTIVE_CPP.contains(TokenStreamUtils.getLanguage((Collection)startTokens))) {
            return false;
        }
        for (int i = startTokens.size() - 1; i > 0; --i) {
            IToken currentToken = (IToken)startTokens.get(i);
            if (currentToken.getType() == ETokenType.RPAREN) {
                return false;
            }
            if (currentToken.getType() != ETokenType.SEMICOLON) continue;
            return true;
        }
        return false;
    }

    private Optional<VariableWrite> createParameter(String type, @Nullable IToken identifier, boolean mustContainTypes, Supplier<String> parameterListParsingErrorSupplier) {
        String parameterName;
        if (identifier != null) {
            parameterName = identifier.getText();
        } else {
            if (mustContainTypes) {
                LOGGER.error(parameterListParsingErrorSupplier.get());
                return Optional.empty();
            }
            parameterName = type;
        }
        if (parameterName != null && parameterName.equals("_")) {
            return Optional.empty();
        }
        this.addToScope(parameterName);
        return Optional.of(new VariableWrite(parameterName).setOther());
    }

    @Override
    public VariableReadWriteInfo parseStatement(List<IToken> tokens) {
        IToken lastToken = (IToken)CollectionUtils.getLast(tokens);
        if (lastToken != null && lastToken.getType() == ETokenType.SEMICOLON) {
            tokens = tokens.subList(0, tokens.size() - 1);
        }
        VariableReadWriteInfo info = new VariableReadWriteInfo();
        if (tokens.isEmpty()) {
            return info;
        }
        List<String> readVariables = this.parseReads(tokens);
        List<String> writtenVariables = this.parseAssignmentsAndDefinitions(tokens, info);
        for (String writtenVariable : writtenVariables) {
            readVariables.remove(writtenVariable);
        }
        info.getReads().addAll(readVariables);
        info.getDereferenceInfo().merge(this.parseDereferences(tokens));
        this.augmentWithSelfModifications(info, tokens);
        this.modifyReadWriteInfoLanguageSpecific(tokens, info);
        return info;
    }

    private List<String> parseAssignmentsAndDefinitions(List<IToken> tokens, VariableReadWriteInfo info) {
        boolean isDefinitionStatement;
        int sizeOfLeadingType = this.getSizeOfLeadingType(tokens);
        boolean bl = isDefinitionStatement = sizeOfLeadingType > 0;
        if (isDefinitionStatement) {
            tokens = tokens.subList(sizeOfLeadingType, tokens.size());
        }
        tokens = DefUseHeuristicUtils.cloneWithoutParenthesesAroundAssignedVar(tokens);
        ArrayList<String> writtenAndNotReadVariables = new ArrayList<String>();
        TokenStreamSplitter splitter = new TokenStreamSplitter(tokens);
        splitter.splitNested(ETokenType.LPAREN, ETokenType.RPAREN);
        splitter.splitNested(ETokenType.LBRACK, ETokenType.RBRACK);
        List tokenStreams = splitter.getTokenStreams();
        for (int i = 0; i < tokenStreams.size(); ++i) {
            boolean isDefinitionPart;
            List splitStream = (List)tokenStreams.get(i);
            boolean bl2 = isDefinitionPart = i == 0 && isDefinitionStatement;
            if (TokenStreamUtils.startsWith((List)splitStream, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACE})) {
                this.parseCpp11ListInitialization(splitStream, info, writtenAndNotReadVariables, isDefinitionStatement);
                continue;
            }
            if (isDefinitionPart && TokenStreamUtils.startsWith((List)splitStream, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.SENTINEL})) {
                this.parseDefinitionWithDirectInitialization(info, splitStream, writtenAndNotReadVariables);
                continue;
            }
            List commaSeparatedParts = TokenStreamUtils.splitWithNesting((List)splitStream, (ETokenType)ETokenType.COMMA, List.of(ETokenType.LBRACE, ETokenType.LT), List.of(ETokenType.RBRACE, ETokenType.GT));
            for (List commaSeparatedPart : commaSeparatedParts) {
                boolean hasTwoSidedOperator = TokenStreamUtils.containsAny((List)commaSeparatedPart, TWO_SIDED_ASSIGNMENT_OPERATOR_SET);
                if (hasTwoSidedOperator) {
                    this.parseAssignmentChain(commaSeparatedPart, isDefinitionPart, info, writtenAndNotReadVariables);
                    continue;
                }
                if (!isDefinitionPart) continue;
                this.parseEmptyDefinition(commaSeparatedPart, info, writtenAndNotReadVariables);
            }
        }
        return writtenAndNotReadVariables;
    }

    private void parseDefinitionWithDirectInitialization(VariableReadWriteInfo info, List<IToken> splitStream, List<String> writtenAndNotReadVariables) {
        String definedVariable = splitStream.get(0).getText();
        info.getDefinitions().add(new VariableWrite(definedVariable).setValue(""));
        writtenAndNotReadVariables.add(definedVariable);
        this.addToScope(definedVariable);
    }

    private void parseCpp11ListInitialization(List<IToken> declaration, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables, boolean isDefinitionStatement) {
        ELanguage language = TokenStreamUtils.getLanguage(declaration);
        CCSMAssert.isTrue(((language == ELanguage.CPP || language == ELanguage.CPP_MS_CLI) && TokenStreamUtils.startsWith(declaration, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACE}) ? 1 : 0) != 0, (String)"This method must be called with C++ code starting with IDENTIFIER LBRACE");
        int tokenIndex = 0;
        while (TokenStreamUtils.hasTokenTypeSequence(declaration, (int)tokenIndex, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACE})) {
            if (isDefinitionStatement) {
                String definedVariable = declaration.get(tokenIndex).getText();
                info.getDefinitions().add(new VariableWrite(definedVariable).setOther());
                writtenAndNotReadVariables.add(definedVariable);
                this.addToScope(definedVariable);
            }
            if ((tokenIndex = TokenStreamUtils.findMatchingClosingToken(declaration, (int)(tokenIndex + 2), (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE)) == -1 || tokenIndex + 2 >= declaration.size()) {
                return;
            }
            if (declaration.get(tokenIndex + 1).getType() != ETokenType.COMMA) continue;
            tokenIndex += 2;
        }
    }

    private void parseAssignmentChain(List<IToken> assignmentChain, boolean isDefinitionPart, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables) {
        List operatorPositions = TokenStreamUtils.findAll(assignmentChain, (ITokenMatcher)ITokenMatcher.anyOfType(TWO_SIDED_ASSIGNMENT_OPERATOR_SET));
        List assignmentParts = TokenStreamUtils.split(assignmentChain, TWO_SIDED_ASSIGNMENT_OPERATOR_SET);
        for (int k = 0; k < assignmentParts.size() - 1; ++k) {
            VariableWrite write;
            boolean isFirstAssignmentOfDefinition = isDefinitionPart && k == 0;
            List leftSide = (List)assignmentParts.get(k);
            String leftIdentifier = DefUseHeuristicUtils.extractSingleTokenText(leftSide, ETokenType.ETokenClass.IDENTIFIER);
            if (leftIdentifier == null || !isFirstAssignmentOfDefinition && !this.isKnownVariableName(leftIdentifier)) continue;
            IToken operator = assignmentChain.get((Integer)operatorPositions.get(k));
            if (operator.getType() == ASSIGNMENT_OPERATOR) {
                write = this.parseNormalAssignment(leftIdentifier, leftSide, (List)assignmentParts.get(k + 1));
                writtenAndNotReadVariables.add(leftIdentifier);
            } else {
                write = new VariableWrite(leftIdentifier);
            }
            if (!isDefinitionPart && this.parseDereferences(leftSide).getDereferencedVariables().contains(leftIdentifier)) {
                write.makeWriteToDereferencedAddress();
            }
            if (isFirstAssignmentOfDefinition) {
                info.getDefinitions().add(write);
                this.addToScope(write.getChangedVariable());
                continue;
            }
            info.getAssignments().add(0, write);
        }
    }

    private VariableWrite parseNormalAssignment(String leftIdentifier, List<IToken> leftSideOfAssignment, List<IToken> rightSideOfAssignment) {
        VariableWrite write = new VariableWrite(leftIdentifier);
        while (!rightSideOfAssignment.isEmpty() && EnumSet.of(ETokenType.AND, ETokenType.MULT).contains(rightSideOfAssignment.get(0).getType())) {
            rightSideOfAssignment = rightSideOfAssignment.subList(1, rightSideOfAssignment.size());
        }
        String rightIdentifier = DefUseHeuristicUtils.extractSingleTokenText(rightSideOfAssignment, ETokenType.ETokenClass.IDENTIFIER);
        String rightLiteral = DefUseHeuristicUtils.extractSingleTokenText(rightSideOfAssignment, ETokenType.ETokenClass.LITERAL);
        if (rightIdentifier != null && this.isKnownVariableName(rightIdentifier)) {
            write.setVariable(rightIdentifier);
        } else if (CppDefUseHeuristic.isNullPointerAssignment(leftSideOfAssignment, rightSideOfAssignment)) {
            write.setNull();
        } else if (rightLiteral != null) {
            write.setValue(rightLiteral);
        }
        if (TokenStreamUtils.startsWith(rightSideOfAssignment, (ETokenType[])new ETokenType[]{ETokenType.NEW})) {
            write.setValue("new");
        }
        return write;
    }

    private void parseEmptyDefinition(List<IToken> commaSeparatedPart, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables) {
        String definedVariable = DefUseHeuristicUtils.extractSingleTokenText(commaSeparatedPart, ETokenType.ETokenClass.IDENTIFIER);
        if (definedVariable != null) {
            info.getDefinitions().add(new VariableWrite(definedVariable).setEmpty());
            writtenAndNotReadVariables.add(definedVariable);
            this.addToScope(definedVariable);
        }
    }

    private void augmentWithSelfModifications(VariableReadWriteInfo info, List<IToken> tokens) {
        List matches = CLikeSelfModificationExpressionPattern.SELF_MODIFICATION_PATTERN.findAll(tokens);
        List identifiers = TokenPatternMatch.getAllStrings((List)matches, (int)0);
        for (String identifier : identifiers) {
            if (!this.isKnownVariableName(identifier)) continue;
            info.getAssignments().add(new VariableWrite(identifier));
        }
    }

    @Override
    public void openNewScope() {
        this.identifierVisibilityScopeStack.openNewScope();
    }

    @Override
    public void closeCurrentScope() {
        this.identifierVisibilityScopeStack.closeCurrentScope();
    }

    @Override
    public void addToScope(String identifier) {
        this.identifierVisibilityScopeStack.addIdentifierToScope(identifier);
    }

    @Override
    public boolean isKnownVariableName(String identifier) {
        return this.identifierVisibilityScopeStack.isKnownVariableName(identifier);
    }

    @Override
    public void addToFileScope(String identifier) {
        this.identifierVisibilityScopeStack.addToFileScope(identifier);
    }

    @Override
    public Set<VariableWrite> getDefinitionsInFileScope() {
        return CollectionUtils.mapToSet(this.identifierVisibilityScopeStack.getKnownIdentifiersOnFileScope(), VariableWrite::new);
    }

    @Override
    public Set<VariableWrite> getDefinitionsInLocalScope() {
        return Collections.emptySet();
    }

    private String skipType(TokenStreamParser parser, ShallowEntity entity) {
        List<IToken> typeModifiers = this.extractTypeModifiers(parser, entity);
        String baseType = CppDefUseHeuristic.extractBaseType(parser, typeModifiers);
        if (baseType == null) {
            return null;
        }
        this.consumeTypeModifiers(parser, entity);
        if (!CppDefUseHeuristic.hasValidArrayNotation(parser) || !CppDefUseHeuristic.skipCppStructMembers(parser)) {
            return null;
        }
        this.consumeTypeModifiers(parser, entity);
        return baseType;
    }

    private List<IToken> extractTypeModifiers(TokenStreamParser parser, ShallowEntity entity) {
        ArrayList<IToken> typeTokens = new ArrayList<IToken>();
        do {
            if (CppDefUseHeuristic.skipAnnotations(parser) != -1) continue;
            LOGGER.error(SourceCodeMessageUtils.createMessage((String)"Found broken annotation in parameter list", (List)parser.getTokens(), null));
            DefUseHeuristicUtils.skipToNextCommaOrEnd(parser);
        } while (typeTokens.addAll(this.consumeTypeModifiers(parser, entity)));
        return typeTokens;
    }

    private static String extractBaseType(TokenStreamParser parser, List<IToken> typeTokens) {
        String baseType = !typeTokens.isEmpty() && TokenStreamUtils.contains(typeTokens, (ETokenType)ETokenType.UNSIGNED) && !PRIMITIVE_NUMERIC_TYPES.contains(parser.currentType()) ? "int" : CppDefUseHeuristic.skipAndReturnBaseType(parser);
        return baseType;
    }

    private List<IToken> consumeTypeModifiers(TokenStreamParser parser, @Nullable ShallowEntity entity) {
        if (entity != null && !LanguageFeatureParser.CPP.isCppMethod(entity)) {
            ArrayList<IToken> consumedTypeModifiers = new ArrayList<IToken>();
            while (parser.isAnyOf(this.typeModifiers) && !parser.currentText().equals("and") && !parser.currentText().equals("bitand")) {
                parser.consumeOneOrZeroOf(this.typeModifiers).ifPresent(consumedTypeModifiers::add);
            }
            return consumedTypeModifiers;
        }
        return parser.consumeAnyOf(this.typeModifiers);
    }

    private List<String> parseReads(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        TokenPattern nonVariableSuffixes = switch (tokens.get(0).getLanguage()) {
            case ELanguage.CPP, ELanguage.CPP_MS_CLI -> TokenPattern.NEVER_MATCHING_PATTERN;
            default -> ETokenType.LPAREN;
        };
        List matches = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).notFollowedBy((Object)nonVariableSuffixes).findAll(tokens);
        ArrayList<String> readIdentifiers = new ArrayList<String>();
        List identifiers = TokenPatternMatch.getAllStrings((List)matches, (int)0);
        for (String identifier : identifiers) {
            if (!this.isKnownVariableName(identifier)) continue;
            readIdentifiers.add(identifier);
        }
        return readIdentifiers;
    }
}

