/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.RuleUtils;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class IfRuleBase
implements IControlFlowRule {
    private final IShallowEntityMatcher elseIfMatcher;
    private final IShallowEntityMatcher elseMatcher;

    protected IfRuleBase(IShallowEntityMatcher elseIfMatcher, IShallowEntityMatcher elseMatcher) {
        this.elseIfMatcher = elseIfMatcher;
        this.elseMatcher = elseMatcher;
    }

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        TransformationInfo transformationInfo = new TransformationInfo();
        this.processIfStatement(entities, context, creator, transformationInfo);
        this.processElseIfBranches(entities, context, creator, transformationInfo);
        this.processElseBranch(entities, context, creator, transformationInfo);
        return new IControlFlowRule.Result(transformationInfo.getConsumedEntities(), transformationInfo.getFirstConsumedEntity(), transformationInfo.getExitNodes());
    }

    protected abstract List<IToken> getIfOrElseIfTokens(ShallowEntity var1);

    protected abstract List<IToken> extractCondition(List<IToken> var1);

    private void processIfStatement(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator, TransformationInfo transformationInfo) throws ConQATException {
        ShallowEntity ifEntity = entities.get(0);
        this.processConditionalStatement(context, creator, transformationInfo, ifEntity);
    }

    private void processElseIfBranches(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator, TransformationInfo transformationInfo) throws ConQATException {
        ShallowEntity elseIfEntity = IfRuleBase.findNextMatchingEntitySkippingPragmaDirectives(this.elseIfMatcher, entities, transformationInfo);
        while (elseIfEntity != null) {
            this.processConditionalStatement(context, creator, transformationInfo, elseIfEntity);
            elseIfEntity = IfRuleBase.findNextMatchingEntitySkippingPragmaDirectives(this.elseIfMatcher, entities, transformationInfo);
        }
    }

    private void processConditionalStatement(DataFlowContext context, ControlFlowCreator creator, TransformationInfo transformationInfo, ShallowEntity conditionalEntity) throws ConQATException {
        List<IToken> conditionalTokens = this.getIfOrElseIfTokens(conditionalEntity);
        ControlFlowNode conditionalNode = context.createNode(conditionalTokens, true);
        RuleUtils.attachLambdaGraphs(conditionalEntity, context, creator, conditionalNode);
        IControlFlowRule.Result thenBranch = IfRuleBase.processThenBranch(context, creator, conditionalNode, (List<ShallowEntity>)conditionalEntity.getChildren());
        transformationInfo.consumeConditionalNode(conditionalNode, this.isConditionAlwaysFulfilled(conditionalTokens), thenBranch.getExitNodes());
    }

    private boolean isConditionAlwaysFulfilled(List<IToken> statementTokens) {
        List<IToken> condition = this.extractCondition(statementTokens);
        return RuleUtils.isConditionAlwaysTrue(condition);
    }

    private static IControlFlowRule.Result processThenBranch(DataFlowContext context, ControlFlowCreator creator, ControlFlowNode parentNode, List<ShallowEntity> thenEntities) throws ConQATException {
        IControlFlowRule.Result thenBranch = RuleUtils.transformInNewScope(creator, context, thenEntities);
        ControlFlowNode.link(parentNode, thenBranch.getEntryNode());
        return thenBranch;
    }

    private void processElseBranch(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator, TransformationInfo transformationInfo) throws ConQATException {
        ShallowEntity elseEntity = IfRuleBase.findNextMatchingEntitySkippingPragmaDirectives(this.elseMatcher, entities, transformationInfo);
        if (elseEntity == null) {
            transformationInfo.addLastNodeAsExitNode();
        } else {
            IControlFlowRule.Result elseBranch = RuleUtils.transformInNewScope(creator, context, (List<ShallowEntity>)elseEntity.getChildren());
            transformationInfo.consumeConditionalNode(elseBranch.getEntryNode(), true, elseBranch.getExitNodes());
        }
    }

    private static ShallowEntity findNextMatchingEntitySkippingPragmaDirectives(IShallowEntityMatcher matcher, List<ShallowEntity> entities, TransformationInfo transformationInfo) {
        if (transformationInfo.getConsumedEntities() >= entities.size()) {
            return null;
        }
        ShallowEntity currentEntity = entities.get(transformationInfo.getConsumedEntities());
        ArrayList<ShallowEntity> pragmaDirectives = new ArrayList<ShallowEntity>();
        while (IfRuleBase.isPragmaDirective(currentEntity)) {
            pragmaDirectives.add(currentEntity);
            int nextEntityIndex = transformationInfo.getConsumedEntities() + pragmaDirectives.size();
            if (nextEntityIndex == entities.size()) {
                return null;
            }
            currentEntity = entities.get(nextEntityIndex);
        }
        if (!matcher.matches(currentEntity)) {
            return null;
        }
        transformationInfo.consumeUnrelatedEntities(pragmaDirectives);
        return currentEntity;
    }

    private static boolean isPragmaDirective(ShallowEntity entity) {
        ELanguage language = ShallowParsingUtils.getLanguage((ShallowEntity)entity);
        if (language != null && !language.isCppOrC()) {
            return false;
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.isEmpty()) {
            return false;
        }
        IToken startToken = (IToken)tokens.get(0);
        return CPreprocessor.isPragmaDirectiveToken((IToken)startToken);
    }

    private static class TransformationInfo {
        private int consumedEntities = 0;
        private ControlFlowNode entryNode;
        private ControlFlowNode lastNode;
        private boolean hitAlwaysTrueCondition = false;
        private final List<ControlFlowNode> exitNodes = new ArrayList<ControlFlowNode>();

        private TransformationInfo() {
        }

        private void consumeConditionalNode(ControlFlowNode conditionalNode, boolean isConditionAlwaysTrue, List<ControlFlowNode> exitNodes) {
            if (!this.hitAlwaysTrueCondition) {
                this.hitAlwaysTrueCondition = isConditionAlwaysTrue;
                if (this.entryNode == null) {
                    this.entryNode = conditionalNode;
                }
                if (this.lastNode != null) {
                    ControlFlowNode.link(this.lastNode, conditionalNode);
                }
                this.lastNode = conditionalNode;
                this.exitNodes.addAll(exitNodes);
            }
            ++this.consumedEntities;
        }

        private void consumeUnrelatedEntities(List<ShallowEntity> nodes) {
            this.consumedEntities += nodes.size();
        }

        private ControlFlowNode getFirstConsumedEntity() {
            return this.entryNode;
        }

        private int getConsumedEntities() {
            return this.consumedEntities;
        }

        private void addLastNodeAsExitNode() {
            if (!this.hitAlwaysTrueCondition) {
                this.exitNodes.add(this.lastNode);
            }
        }

        private List<ControlFlowNode> getExitNodes() {
            return this.exitNodes;
        }
    }
}

