/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cs;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.FalsePositiveFilterUtils;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class IsCastCheckDeadStoreFilter
implements IFalsePositiveFilter {
    private static final TokenPattern IS_CAST_CHECK_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IS}).optional(new Object[]{EnumSet.of(ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.KEYWORD)}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0);
    private static final TokenPattern LAMBDA_CAST_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).alternative(new Object[]{ETokenType.ETokenClass.KEYWORD, new TokenPattern().sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.ETokenClass.IDENTIFIER})}).sequence(new Object[]{ETokenType.RPAREN}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0);

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) {
        List<IToken> tokens = statement.getTokens();
        List matches = IS_CAST_CHECK_PATTERN.findAll(tokens);
        if (!matches.isEmpty()) {
            return IsCastCheckDeadStoreFilter.matchesIsCast(matches, variable, tokens);
        }
        TokenPatternMatch lambdaCastMatch = LAMBDA_CAST_PATTERN.matchFully(tokens);
        if (lambdaCastMatch != null) {
            return IsCastCheckDeadStoreFilter.matchesLambdaCast(variable, element, tokens);
        }
        return false;
    }

    private static boolean matchesLambdaCast(String variable, TokenElementInfo element, List<IToken> tokens) {
        Predicate<ShallowEntity> matchesCurrentTokens = entity -> {
            UnmodifiableList entityTokens = entity.ownStartTokens();
            if (entityTokens.size() == tokens.size() && LAMBDA_CAST_PATTERN.matchFully((List)entityTokens) != null) {
                return tokens.equals(entityTokens);
            }
            return false;
        };
        List matchingEntities = ShallowEntityTraversalUtils.selectEntities(element.getShallowEntitiesWithPreprocessorTokens(), matchesCurrentTokens);
        if (matchingEntities.size() == 1) {
            ShallowEntity currentEntity = (ShallowEntity)matchingEntities.get(0);
            ShallowEntity parentEntity = currentEntity.getParent();
            return parentEntity != null && parentEntity.getSubtype().equals("lambda") && parentEntity.ownStartTokens().size() > 0 && ((IToken)parentEntity.ownStartTokens().get(0)).getText().equals(variable);
        }
        return false;
    }

    private static boolean matchesIsCast(List<TokenPatternMatch> matches, String variable, List<IToken> tokens) {
        for (TokenPatternMatch match : matches) {
            if (!match.groupString(0).equals(variable)) continue;
            return FalsePositiveFilterUtils.isVariableUsedInStatementAfterward(tokens, variable, (Integer)match.groupIndices(0).get(0));
        }
        return false;
    }
}

