/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.javascript;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class TsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="compilerOptions")
    private @Nullable CompilerOptions compilerOptions;

    public void appendResolvedPathMappings(String uniformPathContext, BiConsumer<String, String> mappingsCollector) {
        if (this.compilerOptions == null) {
            return;
        }
        UniformPath baseUrl = UniformPathCompatibilityUtil.convert((String)uniformPathContext).resolve(this.compilerOptions.getBasePath());
        this.compilerOptions.paths.forEach((alias, resolutionPaths) -> {
            for (String resolutionPath : resolutionPaths) {
                mappingsCollector.accept((String)alias, baseUrl.resolve(UniformPathCompatibilityUtil.convertRelative((String)resolutionPath)).toString());
            }
        });
    }

    @VisibleForTesting
    void addPathMapping(String alias, List<String> paths) {
        if (this.compilerOptions == null) {
            this.compilerOptions = new CompilerOptions();
        }
        this.compilerOptions.paths.put(alias, paths);
    }

    @IndexValueClass
    private static class CompilerOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="baseUrl")
        private @Nullable String baseUrl;
        @JsonProperty(value="paths")
        private LinkedHashMap<String, List<String>> paths = new LinkedHashMap();

        private CompilerOptions() {
        }

        private RelativeUniformPath getBasePath() {
            String baseUrl = this.baseUrl;
            if (baseUrl == null) {
                baseUrl = ".";
            }
            return UniformPathCompatibilityUtil.convertRelative((String)baseUrl);
        }
    }
}

