/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.lib.commons.collections.CollectionUtils;

@Index(name="external-analysis-deletions", options={EStorageOption.NO_ROLLBACK})
public class ExternalAnalysisDeletionIndex
implements IProjectIndex {
    private final ValueIndex<Long> delegate;
    private final ConvenientStore store;

    public ExternalAnalysisDeletionIndex(IStore store) {
        this.store = new ConvenientStore(store);
        this.delegate = ValueIndex.forLong((IStore)store);
    }

    public void addCommit(CommitDescriptor commit) throws StorageException {
        this.delegate.setValue(commit.toString(), (Object)System.currentTimeMillis());
    }

    public Set<CommitDescriptor> getCommits() throws StorageException {
        return CollectionUtils.mapToSet((Collection)this.delegate.getAllKeys(), CommitDescriptor::fromStringRepresentation);
    }

    public long getDeletionTimeForCommit(CommitDescriptor commit) throws StorageException {
        return (Long)this.delegate.getValue(commit.toString(), true);
    }

    public boolean isCommitMarkedForDeletion(CommitDescriptor commit) throws StorageException {
        return this.delegate.getValue(commit.toString()) != null;
    }

    public void removeCommits(Collection<CommitDescriptor> commits) throws StorageException {
        this.store.removeWithStrings(CollectionUtils.map(commits, CommitDescriptor::toString));
    }

    public Set<CommitDescriptor> findCommitsMarkedForDeletion(List<CommitDescriptor> commits) throws StorageException {
        List keys = CollectionUtils.map(commits, CommitDescriptor::toString);
        List timestamps = this.delegate.getValues(keys);
        HashSet<CommitDescriptor> commitsMarkedForDeletion = new HashSet<CommitDescriptor>();
        CollectionUtils.forEach(commits, (Iterable)timestamps, (commit, timestamp) -> {
            if (timestamp != null) {
                commitsMarkedForDeletion.add((CommitDescriptor)commit);
            }
        });
        return commitsMarkedForDeletion;
    }
}

