/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.index.external.input.ImportInfoPath;
import com.teamscale.index.external.input.PathCorrector;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMultiFileRangeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionModifier;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;

class TestWiseToLineCoverageIntegrator {
    private final ExternalAnalysisImportSessionIndex sessionIndex;
    private final PathCorrector pathCorrector;
    private final Map<String, LineCoverageInfo> aggregatedLineCoverageByOriginalPath = new HashMap<String, LineCoverageInfo>();

    public TestWiseToLineCoverageIntegrator(ExternalAnalysisImportSessionIndex sessionIndex, PathCorrector pathCorrector) {
        this.sessionIndex = sessionIndex;
        this.pathCorrector = pathCorrector;
    }

    public void convertTestWiseCoverageToLineCoverage(List<ExternalAnalysisImportInfos> importInfos) throws AssertionError {
        for (ExternalAnalysisImportInfos testArtifactPath : importInfos) {
            for (ExternalAnalysisImportInfoMultiFileRangeCoverage testwiseInfo : testArtifactPath.filterByType(ExternalAnalysisImportInfoMultiFileRangeCoverage.class)) {
                testwiseInfo.appendLineCoverageTo(this.aggregatedLineCoverageByOriginalPath);
            }
        }
    }

    public Set<ImportInfoPath> persistState(ExternalAnalysisSessionInfo session) throws StorageException {
        ExternalAnalysisImportInfos newInfo = new ExternalAnalysisImportInfos();
        for (String originalPath : this.aggregatedLineCoverageByOriginalPath.keySet()) {
            newInfo.addInfo(new ExternalAnalysisImportInfoLineCoverage(originalPath, this.aggregatedLineCoverageByOriginalPath.get(originalPath)));
        }
        new ExternalAnalysisImportSessionModifier(this.sessionIndex).storeNewImportInfosForSession(session, newInfo);
        return new HashSet<ImportInfoPath>(this.pathCorrector.correctPaths(this.aggregatedLineCoverageByOriginalPath.keySet()));
    }
}

