/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration;

import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Index(name="migrated-archive-paths", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK})
public class MigratedArchivePathsIndex
implements IGlobalIndex {
    private static final String LOCK_SUFFIX = "LOCK";
    private final KeysOnlyIndex delegate;

    public MigratedArchivePathsIndex(IStore store) {
        this.delegate = new KeysOnlyIndex(store);
    }

    public void addMigratedPath(String archivePath) throws StorageException {
        this.delegate.runLocked(LOCK_SUFFIX, () -> this.delegate.storeKey(archivePath));
    }

    public boolean wasMigrated(String archivePath) throws StorageException {
        return (Boolean)this.delegate.computeLocked(LOCK_SUFFIX, () -> this.delegate.hasKey(archivePath));
    }

    public List<String> getAllPaths() throws StorageException {
        return (List)this.delegate.computeLocked(LOCK_SUFFIX, () -> ((KeysOnlyIndex)this.delegate).listKeys());
    }
}

