/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.core.runtime.impl.worker.RecordingStore;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.external.tools.ExternalAnalysisResultIndexUtils;
import com.teamscale.index.external.tools.StoreModifierBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.lib.commons.collections.PairList;

public class CoverageMergingBackupMinimizer
extends StoreModifierBase {
    private static final SchemaEntry EXTERNAL_ANALYSIS_RESULT_INDEX_SCHEMA = new SchemaEntry(ExternalAnalysisResultIndex.class);
    private int mergedCount = 0;
    private ParentedCommitDescriptor lastWrittenCommit = null;
    private LineCoverageMerger merger = null;

    @Override
    protected Set<String> getChangedStoreNames() {
        return Set.of("external-analysis-results");
    }

    @Override
    protected void modifyStore(String storeName, CompressingStore inputStore, CompressingStore outputStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch) throws StorageException {
        System.out.println("Reading commits...");
        for (Map.Entry<String, List<ParentedCommitDescriptor>> entry : commitsByBranch.entrySet()) {
            String branch = entry.getKey();
            System.out.println("Starting branch " + branch);
            List<ParentedCommitDescriptor> commits = entry.getValue();
            int count = 0;
            for (ParentedCommitDescriptor commitDescriptor : commits) {
                System.out.println("  Commit " + ++count + " of " + commits.size() + " (branch: " + branch + ")");
                ExternalAnalysisResultIndex index = new ExternalAnalysisResultIndex(HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp()).createStore((IStore)inputStore, EXTERNAL_ANALYSIS_RESULT_INDEX_SCHEMA));
                this.processCoverageCommit(outputStore, commitDescriptor, index);
            }
            if (this.merger != null) {
                this.writeMergeToIndex(outputStore);
            }
            System.out.println();
            System.out.println("Before: " + count + " commits. After: " + this.mergedCount + " commits.");
        }
    }

    private void processCoverageCommit(CompressingStore outputStore, ParentedCommitDescriptor commitDescriptor, ExternalAnalysisResultIndex index) throws StorageException {
        ExternalAnalysisCommitInfo commit = (ExternalAnalysisCommitInfo)((Object)index.getCommitInfo());
        String partition = commit.getPartition();
        List<String> paths = index.getAllElementPaths(partition);
        List<ExternalAnalysisResults> results = index.getAnalysisResults(partition, paths);
        if (this.merger == null) {
            this.merger = new LineCoverageMerger(commitDescriptor, paths, results, partition, commit);
            CoverageMergingBackupMinimizer.printlnCommit("in:  ", commit);
        } else if (this.merger.shouldBeMerged(commitDescriptor, partition)) {
            this.merger.merge(commitDescriptor, paths, results);
            CoverageMergingBackupMinimizer.printlnCommit("merge:  ", commit);
        } else {
            this.writeMergeToIndex(outputStore);
            this.merger = new LineCoverageMerger(commitDescriptor, paths, results, partition, commit);
            CoverageMergingBackupMinimizer.printlnCommit("in:  ", commit);
        }
    }

    private void writeMergeToIndex(CompressingStore outputStore) throws StorageException {
        this.lastWrittenCommit = this.merger.writeToIndex(outputStore, this.lastWrittenCommit);
        ++this.mergedCount;
        System.out.println("    merged " + this.merger.getNumberOfMergedCommits() + " commits");
        this.merger = null;
    }

    public static void main(String[] args) {
        LoggingUtils.initLogger();
        CoverageMergingBackupMinimizer.execute(CoverageMergingBackupMinimizer::new, (String[])args);
    }

    private static class LineCoverageMerger {
        private static final int MERGE_THRESHOLD_MILLISECONDS = 100;
        private final ParentedCommitDescriptor initialCommit;
        private ParentedCommitDescriptor latestMergedCommit;
        private final String partition;
        private final ExternalAnalysisCommitInfo commitInfo;
        private final Map<String, ExternalAnalysisResultLineCoverage> mergedResultsByPath = new HashMap<String, ExternalAnalysisResultLineCoverage>();
        private int numberOfMergedCommits = 1;

        private LineCoverageMerger(ParentedCommitDescriptor initialCommit, List<String> paths, List<ExternalAnalysisResults> results, String partition, ExternalAnalysisCommitInfo commitInfo) {
            this.initialCommit = initialCommit;
            this.latestMergedCommit = initialCommit;
            this.partition = partition;
            this.commitInfo = commitInfo;
            this.addLineCoverage(paths, results);
        }

        public boolean shouldBeMerged(ParentedCommitDescriptor subsequentCommit, String partition) {
            if (!partition.equals(this.partition)) {
                return false;
            }
            if (!subsequentCommit.isOnSameBranchAs((CommitDescriptor)this.initialCommit)) {
                return false;
            }
            return subsequentCommit.getTimestamp() - this.latestMergedCommit.getTimestamp() <= 100L;
        }

        public void merge(ParentedCommitDescriptor subsequentCommit, List<String> paths, List<ExternalAnalysisResults> results) {
            this.addLineCoverage(paths, results);
            this.latestMergedCommit = subsequentCommit;
            ++this.numberOfMergedCommits;
        }

        public int getNumberOfMergedCommits() {
            return this.numberOfMergedCommits;
        }

        private PairList<String, ExternalAnalysisResults> createMergedResults() {
            return (PairList)this.mergedResultsByPath.entrySet().stream().collect(PairList.toPairList(Map.Entry::getKey, e -> new ExternalAnalysisResults((ExternalAnalysisResult)e.getValue())));
        }

        public ParentedCommitDescriptor writeToIndex(CompressingStore outputStore, ParentedCommitDescriptor lastWrittenCommit) throws StorageException {
            ParentedCommitDescriptor writeCommit = StoreModifierBase.fixParentCommits(lastWrittenCommit, this.initialCommit);
            PairList<String, ExternalAnalysisResults> mergedResults = this.createMergedResults();
            RecordingStore recordingStore = ExternalAnalysisResultIndexUtils.createRecordingOutputStore(writeCommit, (IStore)outputStore);
            ExternalAnalysisResultIndex resultIndex = new ExternalAnalysisResultIndex((IStore)recordingStore);
            HashSet<String> pathsToRemove = new HashSet<String>(resultIndex.getAllElementPaths(this.partition));
            pathsToRemove.removeAll((Collection<?>)mergedResults.getFirstList());
            resultIndex.removeElementResults(this.partition, new ArrayList<String>(pathsToRemove));
            ExternalAnalysisResultIndexUtils.storeElementResults(this.partition, (List<String>)mergedResults.getFirstList(), (List<String>)mergedResults.getFirstList(), (List<ExternalAnalysisResults>)mergedResults.getSecondList(), resultIndex, Collections.emptySet());
            StoreModifierBase.printlnCommit("out: ", ExternalAnalysisResultIndexUtils.writeCommit(this.commitInfo, recordingStore, resultIndex));
            return writeCommit;
        }

        private void addLineCoverage(List<String> paths, List<ExternalAnalysisResults> results) {
            for (int i = 0; i < results.size(); ++i) {
                ExternalAnalysisResults resultList = results.get(i);
                String path = paths.get(i);
                List<ExternalAnalysisResultLineCoverage> coverageList = resultList.getByType(ExternalAnalysisResultLineCoverage.class);
                for (ExternalAnalysisResultLineCoverage coverage : coverageList) {
                    this.mergedResultsByPath.merge(path, coverage, ExternalAnalysisResultLineCoverage::mergeCoverage);
                }
            }
        }
    }
}

