/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.fileloaders;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.configuration.MetricThresholdConfigurationUtils;
import com.teamscale.index.fileloaders.BinaryConfigurationLoaderBase;
import com.teamscale.index.fileloaders.FileLoader;
import java.util.Collections;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@FileLoader(extension="tsthresholds")
public class MetricThresholdConfigurationLoader
extends BinaryConfigurationLoaderBase {
    public static final String EXTENSION = "tsthresholds";

    @Override
    protected void createConfiguration(IndexLayer indexLayer, byte[] fileContent) throws StorageException, MigrationException {
        MetricThresholdConfigurationIndex metricThresholdIndex = (MetricThresholdConfigurationIndex)indexLayer.openGlobalIndex(MetricThresholdConfigurationIndex.class);
        GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
        try {
            MetricThresholdConfigurationUtils.createMetricThresholdConfiguration((ObjectNode)JsonUtils.deserializeFromJson((String)StringUtils.bytesToString((byte[])fileContent), ObjectNode.class), metricThresholdIndex, null, true, globalStorageSystem, Collections.emptyMap());
        }
        catch (JsonSerializationException e) {
            throw new MigrationException("Could not load threshold configuration", (Throwable)e);
        }
    }
}

