/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.EBlacklistingOption;
import com.teamscale.index.findings.calculation.EPendingExclusionOption;
import com.teamscale.index.findings.calculation.ExcludedFindingsCount;
import com.teamscale.index.findings.calculation.FilteredFindingsList;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class BasicFindingFilterUtils {
    private static final String INLINE_CODE_MARKDOWN_MARKER = "`";

    public static FilteredFindingsList filterFindings(List<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings, FindingsCalculationInfo calculationInfo) throws StorageException {
        CodeScopeAware findingTypeIds = CodeScopeAware.fromMap(findings.stream().collect(Collectors.groupingBy(TrackedFinding::getCodeScopeName, Collectors.mapping(IndexFinding::getTypeId, Collectors.toSet()))));
        CodeScopeAware findingTypeDescriptions = ((FindingsSchemaIndex)calculationInfo.projectStorageSystem().openProjectIndex(FindingsSchemaIndex.class, null)).getFindingTypeDescriptions(findingTypeIds);
        return BasicFindingFilterUtils.filterFindings(findings, filterSettings, (CodeScopeAware<Map<String, FindingTypeDescription>>)findingTypeDescriptions);
    }

    public static FilteredFindingsList filterFindings(List<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings, CodeScopeAware<Map<String, FindingTypeDescription>> findingTypeDescriptions) {
        List<ExtendedTrackedFinding> filteredFindings = findings;
        filteredFindings = BasicFindingFilterUtils.filterByAssessment(filteredFindings, filterSettings);
        filteredFindings = BasicFindingFilterUtils.filterByIncludedAndExcludedPaths(filteredFindings, filterSettings);
        filteredFindings = BasicFindingFilterUtils.filterByRegex(filteredFindings, filterSettings, findingTypeDescriptions);
        filteredFindings = BasicFindingFilterUtils.filterByGuideline(filteredFindings, filterSettings);
        filteredFindings = BasicFindingFilterUtils.filterTaskRelatedFindings(filteredFindings, filterSettings);
        ExcludedFindingsCount excludedFindingsCount = ExcludedFindingsCount.from(BasicFindingFilterUtils.filterByCategoriesGroupsTypes(filteredFindings, filterSettings));
        filteredFindings = BasicFindingFilterUtils.filterByFindingExclusionType(filteredFindings, filterSettings.getBlacklistingOption(), filterSettings.getPendingExclusionOption());
        List<ExtendedTrackedFinding> categoryFilteredFindings = BasicFindingFilterUtils.filterByCategoriesGroupsTypes(filteredFindings, filterSettings);
        return new FilteredFindingsList(filteredFindings, excludedFindingsCount, categoryFilteredFindings);
    }

    @VisibleForTesting
    static List<ExtendedTrackedFinding> filterByCategoriesGroupsTypes(Collection<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings) {
        List<String> filters = filterSettings.getCategoryGroupTypeFilters();
        boolean invertFilters = filterSettings.isInvertCategoryGroupTypeFilters();
        if (filters == null || filters.isEmpty()) {
            if (invertFilters) {
                return new ArrayList<ExtendedTrackedFinding>();
            }
            return new ArrayList<ExtendedTrackedFinding>(findings);
        }
        ArrayList<ExtendedTrackedFinding> result = new ArrayList<ExtendedTrackedFinding>();
        for (ExtendedTrackedFinding finding : findings) {
            boolean excluded = false;
            for (String filter : filters) {
                if (!BasicFindingFilterUtils.isFilteredOut(filter, finding)) continue;
                excluded = true;
                break;
            }
            if (excluded != invertFilters) continue;
            result.add(finding);
        }
        return result;
    }

    private static List<ExtendedTrackedFinding> filterByAssessment(List<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings) {
        List<ETrafficLightColor> assessmentFilters = filterSettings.getAssessmentFilters();
        if (assessmentFilters == null || assessmentFilters.isEmpty()) {
            return findings;
        }
        ArrayList<ExtendedTrackedFinding> filteredFindings = new ArrayList<ExtendedTrackedFinding>();
        for (ExtendedTrackedFinding finding : findings) {
            if (assessmentFilters.contains(finding.getAssessment())) continue;
            filteredFindings.add(finding);
        }
        return filteredFindings;
    }

    @VisibleForTesting
    static List<ExtendedTrackedFinding> filterByIncludedAndExcludedPaths(Collection<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings) {
        IncludeExcludeAntPatternSupport includeExcludePattern = new IncludeExcludeAntPatternSupport(true, filterSettings.getIncludedPaths(), filterSettings.getExcludedPaths());
        return findings.stream().filter(finding -> includeExcludePattern.isIncluded(finding.getLocation().getUniformPath())).toList();
    }

    @VisibleForTesting
    static List<ExtendedTrackedFinding> filterByRegex(List<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings, CodeScopeAware<Map<String, FindingTypeDescription>> findingTypeDescriptionByTypeId) {
        return BasicFindingFilterUtils.filterByRegex(findings, filterSettings.getRegexFilter(), filterSettings.isExcludeRegexFilter(), findingTypeDescriptionByTypeId);
    }

    private static List<ExtendedTrackedFinding> filterByGuideline(List<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings) {
        String guidelineFilter = filterSettings.getGuidelineFilter();
        if (StringUtils.isEmpty((String)guidelineFilter)) {
            return findings;
        }
        return CollectionUtils.filter(findings, finding -> {
            SetMap guidelineMapping = finding.getGuidelineMapping();
            return guidelineMapping.containsCollection((Object)guidelineFilter) && !CollectionUtils.intersectionSet(filterSettings.getGuidelineRulesFilter(), (Collection[])new Collection[]{guidelineMapping.getCollection((Object)guidelineFilter)}).isEmpty();
        });
    }

    private static boolean isFilteredOut(String filter, TrackedFinding finding) {
        return finding.getCategoryName().equals(filter) || finding.getQualifiedGroupName().equals(filter) || finding.getTypeId().equals(filter);
    }

    private static List<ExtendedTrackedFinding> filterByRegex(List<ExtendedTrackedFinding> findings, Pattern regex, boolean excludeMatches, CodeScopeAware<Map<String, FindingTypeDescription>> findingTypeDescriptionByTypeId) {
        if (regex == null) {
            return findings;
        }
        return CollectionUtils.filter(findings, finding -> {
            FindingTypeDescription findingTypeDescription = (FindingTypeDescription)((Map)findingTypeDescriptionByTypeId.getValue(finding.getCodeScopeName())).get(finding.getTypeId());
            CCSMAssert.isNotNull((Object)findingTypeDescription, (String)("No finding type description for " + finding.getTypeId()));
            return excludeMatches != BasicFindingFilterUtils.isIncluded(finding, regex, findingTypeDescription);
        });
    }

    private static boolean isIncluded(TrackedFinding finding, Pattern pattern, FindingTypeDescription findingTypeDescription) {
        List<String> textsToMatch = BasicFindingFilterUtils.getTextsToMatchRegex(finding, findingTypeDescription);
        for (String textToMatch : textsToMatch) {
            if (!pattern.matcher(textToMatch).find()) continue;
            return true;
        }
        return false;
    }

    private static List<String> getTextsToMatchRegex(TrackedFinding finding, FindingTypeDescription findingTypeDescription) {
        ArrayList<String> textsToMatch = new ArrayList<String>();
        String messageInMarkdown = finding.getMessage();
        String message = messageInMarkdown.replace(INLINE_CODE_MARKDOWN_MARKER, "");
        message = MarkupUtils.unescapeMarkdownRelevantSymbols((String)message);
        textsToMatch.add(message);
        textsToMatch.add(finding.getLocationString());
        textsToMatch.add(finding.getCategoryName());
        textsToMatch.add(finding.getGroupName());
        textsToMatch.add(findingTypeDescription.getName());
        textsToMatch.add(findingTypeDescription.getTool().getReadableName());
        for (Map.Entry entry : finding.getProperties().entrySet()) {
            textsToMatch.add((String)entry.getKey());
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            textsToMatch.add((String)value);
        }
        return textsToMatch;
    }

    private static List<ExtendedTrackedFinding> filterTaskRelatedFindings(List<ExtendedTrackedFinding> findings, BasicFindingsFilterSettings filterSettings) {
        if (!filterSettings.isFilterFindingsAddedToTasks()) {
            return findings;
        }
        return CollectionUtils.filter(findings, finding -> finding.getNumberOfTasks() == 0);
    }

    public static List<ExtendedTrackedFinding> filterByFindingExclusionType(List<ExtendedTrackedFinding> findings, EBlacklistingOption blacklistingOption, EPendingExclusionOption pendingExclusionOption) {
        return CollectionUtils.filter(findings, finding -> BasicFindingFilterUtils.shouldFindingBeIncluded(finding.getBlacklistInfo().orElse(null), blacklistingOption, pendingExclusionOption));
    }

    private static boolean shouldFindingBeIncluded(FindingBlacklistInfo blacklistInfo, EBlacklistingOption blacklistingOption, EPendingExclusionOption pendingExclusionOption) {
        EFindingBlacklistType blacklistType = null;
        if (blacklistInfo != null) {
            blacklistType = blacklistInfo.getType();
        }
        return blacklistingOption.filter.test(blacklistType) && (blacklistInfo == null || pendingExclusionOption.isIncluded(blacklistInfo.getApprovalState()));
    }

    private BasicFindingFilterUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

