/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cppcheck;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.concurrency.WrappedExecutorServiceProducer;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.index.configuration.tools.CppcheckConfigurationBase;
import com.teamscale.index.configuration.tools.CppcheckOpenSourceConfiguration;
import com.teamscale.index.configuration.tools.CppcheckPremiumConfiguration;
import com.teamscale.index.findings.ClangTidyAndCppcheckRunnerBase;
import com.teamscale.index.findings.CppFileUtils;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppIntegratedToolUtils;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.IntegratedToolUtils;
import com.teamscale.index.findings.clangtidy.ProcessWrapper;
import com.teamscale.index.findings.clangtidy.ShallowCodeFileRepresentation;
import com.teamscale.index.findings.cppcheck.CppcheckSynchronizer;
import com.teamscale.index.findings.cppcheck.LineOffsetConverterCache;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.core.registry.GuidelineMapping;
import eu.cqse.check.framework.core.ruleset.RulesetInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CppcheckRunner
extends ClangTidyAndCppcheckRunnerBase {
    public static final String CPPCHECK_EXE_VM_PROPERTY_NAME = "com.teamscale.cppcheck-exe";
    public static final String CPPCHECK_LICENSE_FILE_PATH_VM_PROPERTY_NAME = "com.teamscale.cppcheck-license-path";
    private static final String CPPCHECK_MAX_PARALLEL_PROCESSES_VM_OPTION = "com.teamscale.cppcheck.max-num-parallel-processes";
    private static final String CPPCHECK_MAX_PARALLEL_PROCESSES_DEFAULT = "5";
    private static final String CPPCHECK_PROCESS_TIMEOUT_VM_OPTION = "com.teamscale.cppcheck.process_timeout_minutes";
    private static final String CPPCHECK_PROCESS_TIMEOUT_DEFAULT = "7";
    private static final ExecutorService CPPCHECK_JOB_EXECUTOR = WrappedExecutorServiceProducer.newFixedThreadPool((int)Integer.parseInt(System.getProperty("com.teamscale.cppcheck.max-num-parallel-processes", "5")));
    public static final String CPPCHECK_EXECUTABLE_DEFAULT_NAME = "cppcheck";
    public static final String CPPCHECK_PREMIUM_DOCKER_DEFAULT_LOCATION = "/opt/cppcheck-premium/cppcheck";
    private static final String COMPILE_COMMANDS_FILE_NAME = "compile_commands.json";
    private static final String CPPCHECK_SUPPRESS_CHECK_FILE = "suppress.txt";
    public static final String CPPCHECK_COMMAND_TXT_FILE_NAME = "CppcheckCommand.txt";
    private static final String CPPCHECK_COMMAND_LANGUAGE_C = "c";
    private static final String CPPCHECK_COMMAND_LANGUAGE_CPP = "c++";
    private static final String CPPCHECK_COMMAND_ENABLE_ARGUMENTS = "warning,style,performance,portability,information,missingInclude";
    private static final Set<String> CONFIG_CHECKS = Set.of("missingInclude", "missingIncludeSystem", "premium-missingInclude", "premium-missingIncludeSystem");
    private static final Set<String> CHECKS_WITH_UNECESSARY_WARNING = Set.of("missingIncludeSystem", "premium-missingIncludeSystem");
    private static final String STANDARD_LIBRARY_HEADER_NOTE = " Please note: Cppcheck does not need standard library headers to get proper results.";
    private static final String CPPCHECK_PREMIUM_CHECKID_PREFIX = "premium-";
    private static final String BACKUP_TIMEOUT_SETUPS_JVM_PROPERTY_NAME = "com.teamscale.debug.cppcheck.timeout.setup_backup_dir";
    private static final File SETUP_BACKUP_DIRECTORY = Optional.ofNullable(System.getProperty("com.teamscale.debug.cppcheck.timeout.setup_backup_dir")).map(File::new).orElse(null);
    private static final Charset CHARSET = FileSystemUtils.SYSTEM_CHARSET;

    public static ListMap<String, IndexFinding> prepareAndRunCppcheck(List<BasicTokenElementInfo> filesToAnalyze, File tempDirectory, CodeScopeAware<Map<String, CheckMapping>> selectedCheckMappings, CodeScopeAware<String> enabledChecksForCRegex, CodeScopeAware<List<String>> globalCompilerArgumentsPerCodeScope, boolean dryRun, CppIncludeHandler includeHandler, boolean cppCheckPremiumEnabled, CppToolAnalysisTokenElementDetails tokenElementDetails) throws IOException, StorageException {
        ListMap findingsByAnalysisPath = new ListMap();
        File codeDirectory = new File(tempDirectory, "code");
        FileSystemUtils.ensureDirectoryExists((Path)codeDirectory.toPath());
        Map<String, Set<CppIncludeHandler.IncludeFile>> relevantIncludeFilesMap = CppcheckRunner.computeRelevantIncludeFilesMap(filesToAnalyze, includeHandler, tokenElementDetails.includePathDetails());
        Map<String, ShallowCodeFileRepresentation> fileContents = CppcheckRunner.loadFileContents(filesToAnalyze, relevantIncludeFilesMap, includeHandler);
        CppcheckRunner.writeFiles(fileContents.values(), codeDirectory);
        LineOffsetConverterCache lineOffsetConverterCache = new LineOffsetConverterCache(fileContents);
        if (dryRun) {
            for (int i = 0; i < filesToAnalyze.size(); ++i) {
                BasicTokenElementInfo element = filesToAnalyze.get(i);
                CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
                Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles = relevantIncludeFilesMap.getOrDefault(element.getUniformPath(), Collections.emptySet());
                String mainFile = CppFileUtils.determineTargetFilePathForProcessBuilder(element.getUniformPath(), codeDirectory);
                CppcheckRunParameters cppcheckRunParameters = new CppcheckRunParameters("check_" + i, element, mainFile, false, (Map)selectedCheckMappings.getValue(codeScopeName), cppCheckPremiumEnabled, true, (ListMap<String, RulesetInfo>)GuidelineMapping.getInstance().getRulesByCheckId(Set.of(element.getLanguage())), codeDirectory);
                CppcheckRunner.setupConfigAndRunForElement((List)globalCompilerArgumentsPerCodeScope.getValue(codeScopeName), (ListMap<String, IndexFinding>)findingsByAnalysisPath, relevantIncludeFiles, new File(tempDirectory, "check" + i), includeHandler, cppcheckRunParameters, lineOffsetConverterCache, tokenElementDetails);
            }
            return findingsByAnalysisPath;
        }
        Map<ELanguage, ListMap<String, RulesetInfo>> guidelineRulesByLanguage = CppcheckRunner.loadGuidelineMappingRulesByLanguageMap();
        ArrayList<Callable<Void>> cppcheckJobs = new ArrayList<Callable<Void>>();
        for (int i = 0; i < filesToAnalyze.size(); ++i) {
            CppcheckRunParameters cppcheckRunParameters;
            int finalI = i;
            BasicTokenElementInfo element = filesToAnalyze.get(i);
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
            Map<String, CheckMapping> enabledChecksForC = CppcheckRunner.filterChecksByRegex((Map)selectedCheckMappings.getValue(codeScopeName), (String)enabledChecksForCRegex.getValueWithDefault(codeScopeName));
            Set relevantIncludeFiles = relevantIncludeFilesMap.getOrDefault(element.getUniformPath(), Collections.emptySet());
            String mainFile = CppFileUtils.determineTargetFilePathForProcessBuilder(element.getUniformPath(), codeDirectory);
            Map<String, CheckMapping> selectedChecksForElement = CppcheckRunner.getSelectedChecksForElement((Map)selectedCheckMappings.getValue(codeScopeName), element, enabledChecksForC);
            Map<String, CheckMapping> enabledConfigChecks = CppcheckRunner.filterMatchingEntries(selectedChecksForElement, CONFIG_CHECKS::contains);
            Map<String, CheckMapping> enabledNonConfigChecks = CppcheckRunner.filterMatchingEntries(selectedChecksForElement, checkId -> !CONFIG_CHECKS.contains(checkId));
            List globalCompilerArguments = (List)globalCompilerArgumentsPerCodeScope.getValue(codeScopeName);
            ListMap<String, RulesetInfo> guidelineMappingRules = guidelineRulesByLanguage.get(element.getLanguage());
            if (!enabledConfigChecks.isEmpty()) {
                cppcheckRunParameters = new CppcheckRunParameters("check_config" + finalI, element, mainFile, true, enabledConfigChecks, cppCheckPremiumEnabled, false, guidelineMappingRules, codeDirectory);
                cppcheckJobs.add(() -> CppcheckRunner.setupConfigAndRunForElement(globalCompilerArguments, (ListMap<String, IndexFinding>)findingsByAnalysisPath, relevantIncludeFiles, new File(tempDirectory, "check_config" + finalI), includeHandler, cppcheckRunParameters, lineOffsetConverterCache, tokenElementDetails));
            }
            if (enabledNonConfigChecks.isEmpty()) continue;
            cppcheckRunParameters = new CppcheckRunParameters("check_" + finalI, element, mainFile, false, enabledNonConfigChecks, cppCheckPremiumEnabled, false, guidelineMappingRules, codeDirectory);
            cppcheckJobs.add(() -> CppcheckRunner.setupConfigAndRunForElement(globalCompilerArguments, (ListMap<String, IndexFinding>)findingsByAnalysisPath, relevantIncludeFiles, new File(tempDirectory, "check_" + finalI), includeHandler, cppcheckRunParameters, lineOffsetConverterCache, tokenElementDetails));
        }
        CppcheckRunner.executeJobsInParallel(cppcheckJobs, CPPCHECK_JOB_EXECUTOR, CPPCHECK_EXECUTABLE_DEFAULT_NAME);
        return findingsByAnalysisPath;
    }

    private static Map<String, CheckMapping> filterMatchingEntries(Map<String, CheckMapping> inputMap, Predicate<String> matchingCondition) {
        HashMap<String, CheckMapping> result = new HashMap<String, CheckMapping>();
        for (Map.Entry<String, CheckMapping> entry : inputMap.entrySet()) {
            if (!matchingCondition.test(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<ELanguage, ListMap<String, RulesetInfo>> loadGuidelineMappingRulesByLanguageMap() {
        HashMap<ELanguage, ListMap<String, RulesetInfo>> result = new HashMap<ELanguage, ListMap<String, RulesetInfo>>();
        for (ELanguage language : CppcheckSynchronizer.SUPPORTED_LANGUAGES) {
            result.put(language, (ListMap<String, RulesetInfo>)GuidelineMapping.getInstance().getRulesByCheckId(Set.of(language)));
        }
        return result;
    }

    private static Map<String, CheckMapping> filterChecksByRegex(Map<String, CheckMapping> selectedChecks, String regex) {
        if (selectedChecks == null) {
            return new LinkedHashMap<String, CheckMapping>();
        }
        if (regex == null) {
            return selectedChecks;
        }
        HashMap<String, CheckMapping> result = new HashMap<String, CheckMapping>();
        for (Map.Entry<String, CheckMapping> entry : selectedChecks.entrySet()) {
            if (!entry.getKey().matches(regex)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<String, CheckMapping> getSelectedChecksForElement(Map<String, CheckMapping> selectedChecks, BasicTokenElementInfo element, Map<String, CheckMapping> enabledChecksForC) {
        ELanguage language = element.getLanguage();
        if (language == ELanguage.C) {
            return enabledChecksForC;
        }
        return selectedChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Void setupConfigAndRunForElement(List<String> globalCompilerArguments, ListMap<String, IndexFinding> findingsByAnalysisPath, Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles, File checkDirectory, CppIncludeHandler includeHandler, CppcheckRunParameters jobParameters, LineOffsetConverterCache lineOffsetConverterCache, CppToolAnalysisTokenElementDetails tokenElementDetails) {
        LOGGER.debug("starting cppcheck job " + jobParameters.jobId);
        try {
            FileSystemUtils.ensureDirectoryExists((Path)checkDirectory.toPath());
            List<String> compilerCommandAndArguments = CppcheckRunner.buildCompilerCommandsAndArguments(jobParameters.basicElement, globalCompilerArguments, relevantIncludeFiles, includeHandler, tokenElementDetails);
            CppcheckRunner.writeCppcheckRunConfigFiles(jobParameters.enabledCheckMappings.keySet(), compilerCommandAndArguments, checkDirectory, jobParameters.codeDirectory, jobParameters.mainFilePath, jobParameters.isCppcheckPremium);
            List<IndexFinding> findingsFromAnalysisOfElement = CppcheckRunner.runCppcheckOnElement(checkDirectory, jobParameters.codeDirectory, jobParameters, lineOffsetConverterCache);
            ListMap<String, IndexFinding> listMap = findingsByAnalysisPath;
            synchronized (listMap) {
                findingsByAnalysisPath.addAll((Object)jobParameters.basicElement.getUniformPath(), findingsFromAnalysisOfElement);
            }
        }
        catch (IOException | StorageException e) {
            LOGGER.error("Exception while running cppcheck for uniform path {}", (Object)jobParameters.basicElement.getUniformPath(), (Object)e);
            LOGGER.debug("finishing cppcheck job " + jobParameters.jobId + " with error");
        }
        LOGGER.debug("finishing cppcheck job " + jobParameters.jobId);
        return null;
    }

    private static @NonNull List<String> buildCompilerCommandsAndArguments(BasicTokenElementInfo element, List<String> globalCompilerArguments, Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles, CppIncludeHandler includeHandler, CppToolAnalysisTokenElementDetails tokenElementDetails) throws StorageException {
        return ClangTidyAndCppcheckRunnerBase.concatenateCompilerArguments(includeHandler.determineCompilerCommands(element, relevantIncludeFiles, tokenElementDetails, true), globalCompilerArguments);
    }

    private static List<IndexFinding> runCppcheckOnElement(File checkDirectory, File codeDirectory, CppcheckRunParameters jobParameters, LineOffsetConverterCache lineOffsetConverterCache) throws IOException {
        ProcessWrapper process = CppcheckRunner.createProcessWrapper(codeDirectory, checkDirectory, jobParameters.isConfigCheck, jobParameters.basicElement, jobParameters.isCppcheckPremium);
        CppcheckRunner.writeCommandFile(List.of(process), checkDirectory);
        if (jobParameters.isDryRun) {
            return Collections.emptyList();
        }
        List<CppcheckResultItem> resultItems = CppcheckRunner.runCppcheck(process, jobParameters.mainFilePath, checkDirectory, codeDirectory);
        List<IndexFinding> findings = CppcheckRunner.convertCppcheckResultsToFindings(codeDirectory, jobParameters.basicElement, resultItems, jobParameters.isCppcheckPremium, jobParameters.enabledCheckMappings, jobParameters.guidelineRulesPerCheckId, lineOffsetConverterCache);
        return findings;
    }

    private static void writeCppcheckRunConfigFiles(Set<String> checkSelector, List<String> compilerCommandAndArguments, File checkDirectory, File codeDirectory, String mainFile, boolean isPremium) throws IOException {
        CppcheckRunner.writeCppcheckConfig(checkDirectory, checkSelector, isPremium);
        File compilationCommand = new File(checkDirectory, COMPILE_COMMANDS_FILE_NAME);
        CppIncludeHandler.writeCompilationDb(codeDirectory, compilationCommand, compilerCommandAndArguments, mainFile, CHARSET);
    }

    private static List<CppcheckResultItem> runCppcheck(ProcessWrapper process, String mainFile, File checkDirectory, File codeDirectory) {
        int returnCode;
        process.setOutputConsumer(t -> {});
        StringBuilder errorStreamOutput = new StringBuilder();
        process.setErrorConsumer(line -> errorStreamOutput.append((String)line).append('\n'));
        int timeoutMinutes = CppcheckRunner.determineCppcheckProcessTimeoutMinutes();
        try {
            returnCode = process.runWithTimeoutException(timeoutMinutes);
        }
        catch (TimeoutException e) {
            IntegratedToolUtils.reportTimeout(e.getMessage(), errorStreamOutput.toString(), mainFile, List.of(checkDirectory, codeDirectory), CPPCHECK_EXECUTABLE_DEFAULT_NAME, SETUP_BACKUP_DIRECTORY);
            return Collections.emptyList();
        }
        if (returnCode != 0) {
            LOGGER.warn("Errors when running cppcheck on file {}", (Object)mainFile);
        }
        return CppcheckRunner.parseResultItemsFromXML(errorStreamOutput.toString(), mainFile);
    }

    private static List<CppcheckResultItem> parseResultItemsFromXML(String errorStreamOutput, String mainFile) {
        ArrayList<CppcheckResultItem> result = new ArrayList<CppcheckResultItem>();
        try {
            Document document = XMLUtils.parse((InputSource)new InputSource(new StringReader(errorStreamOutput)));
            Element errorsNode = XMLUtils.getNamedChild((Element)document.getDocumentElement(), (String)"errors");
            if (errorsNode == null) {
                return List.of();
            }
            List errorsNodeChildren = XMLUtils.getNamedChildren((Element)errorsNode, (String)"error");
            for (Element errorNode : errorsNodeChildren) {
                Optional<CppcheckResultItem> cppcheckResultItem = CppcheckRunner.parseResultItemFromCppcheckErrorNode(errorNode);
                if (!cppcheckResultItem.isPresent()) continue;
                result.add(cppcheckResultItem.get());
            }
        }
        catch (IOException | SAXException e) {
            LOGGER.error("Error while parsing cppcheck result for file {}. Ignoring results for this file.", (Object)mainFile, (Object)e);
        }
        return result;
    }

    private static Optional<CppcheckResultItem> parseResultItemFromCppcheckErrorNode(Element errorNode) {
        NamedNodeMap errorNodeAttributes = errorNode.getAttributes();
        if (!CppcheckRunner.containsAllItems(errorNodeAttributes, "id", "msg")) {
            LOGGER.error("Can't parse a cppcheck result item. Continuing with next item. Content: " + errorNode.toString());
            return Optional.empty();
        }
        List locations = XMLUtils.getNamedChildren((Element)errorNode, (String)"location");
        CppcheckCodeLocation mainLocation = null;
        ArrayList<Pair<CppcheckCodeLocation, String>> secondaryLocations = new ArrayList<Pair<CppcheckCodeLocation, String>>();
        for (Node locationNode : locations) {
            NamedNodeMap locationNodeAttributes = locationNode.getAttributes();
            if (!CppcheckRunner.containsAllItems(locationNodeAttributes, "file", "line", "column")) {
                LOGGER.error("Can't parse a cppcheck result item. Continuing with next item. Content: " + errorNode.toString());
                return Optional.empty();
            }
            String filePath = locationNodeAttributes.getNamedItem("file").getNodeValue();
            String line = locationNodeAttributes.getNamedItem("line").getNodeValue();
            String column = locationNodeAttributes.getNamedItem("column").getNodeValue();
            if (!StringUtils.isInteger((String)line) || !StringUtils.isInteger((String)column)) continue;
            CppcheckCodeLocation location = new CppcheckCodeLocation(filePath, Integer.parseInt(line), Integer.parseInt(column));
            Node infoMessage = locationNodeAttributes.getNamedItem("info");
            if (mainLocation == null) {
                mainLocation = location;
                continue;
            }
            if (infoMessage == null) continue;
            secondaryLocations.add((Pair<CppcheckCodeLocation, String>)new Pair((Object)location, (Object)infoMessage.getTextContent()));
        }
        String ruleId = errorNodeAttributes.getNamedItem("id").getNodeValue();
        String message = errorNodeAttributes.getNamedItem("msg").getNodeValue();
        return Optional.of(new CppcheckResultItem(mainLocation, message, ruleId, secondaryLocations));
    }

    private static boolean containsAllItems(NamedNodeMap locationNodeAttributes, String ... attributeNames) {
        for (String attributeName : attributeNames) {
            if (locationNodeAttributes.getNamedItem(attributeName) != null) continue;
            return false;
        }
        return true;
    }

    private static int determineCppcheckProcessTimeoutMinutes() {
        String optionValue = System.getProperty(CPPCHECK_PROCESS_TIMEOUT_VM_OPTION, CPPCHECK_PROCESS_TIMEOUT_DEFAULT);
        try {
            return Integer.parseInt(optionValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Could not parse the value of the VM option com.teamscale.cppcheck.process_timeout_minutes as an integer. This must be a timeout (positive integer) in minutes. The value is `" + optionValue + "`.");
        }
    }

    private static ProcessWrapper createProcessWrapper(File codeDirectory, File checkDir, boolean isConfigCheckRun, BasicTokenElementInfo element, boolean isPremium) {
        String cppcheckExe = CppcheckRunner.loadConfiguredCppcheckExe();
        ProcessWrapper process = new ProcessWrapper(cppcheckExe);
        process.setWorkingDirectory(codeDirectory);
        process.addArgument("--enable=warning,style,performance,portability,information,missingInclude");
        if (isPremium) {
            String propertyValue = System.getProperty(CPPCHECK_LICENSE_FILE_PATH_VM_PROPERTY_NAME);
            if (propertyValue != null) {
                process.addArgument("--premium-license-file=" + propertyValue);
            } else {
                LicenseManager licenseManager = LicenseManager.getInstance();
                String license = StringUtils.stripPrefix((String)licenseManager.getLicenseLocation(), (String)"file:");
                process.addArgument("--premium-license-file=" + license);
            }
            if (element.getLanguage() == ELanguage.C || element.getLanguage() == ELanguage.OBJECTIVE_C) {
                process.addArgument("--premium=misra-c-2023");
                process.addArgument("--premium=cert-c-2016");
            } else {
                process.addArgument("--premium=misra-cpp-2023");
                process.addArgument("--premium=cert-cpp-2016");
                process.addArgument("--premium=autosar");
            }
        } else {
            process.addArgument("--addon=misra");
        }
        process.addArgument("--output-format=xml");
        process.addArgument("--suppressions-list=" + checkDir.getAbsolutePath() + "/suppress.txt");
        process.addArgument("--project=" + new File(checkDir, COMPILE_COMMANDS_FILE_NAME).getAbsolutePath());
        if (isConfigCheckRun) {
            process.addArgument("--check-config");
        }
        if (element.getLanguage() == ELanguage.C) {
            process.addArgument("--language=c");
        } else if (element.getLanguage() == ELanguage.CPP || element.getLanguage() == ELanguage.CPP_MS_CLI) {
            process.addArgument("--language=c++");
        }
        return process;
    }

    private static void writeCommandFile(List<ProcessWrapper> processes, File checkDir) throws IOException {
        FileSystemUtils.writeFileUTF8((Path)new File(checkDir, CPPCHECK_COMMAND_TXT_FILE_NAME).toPath(), (String)("This is the command we use to run cppcheck (using this folder as working directory):\n" + processes.stream().map(ProcessWrapper::getCommand).collect(Collectors.joining("\n\n"))));
    }

    private static void writeCppcheckConfig(File checkDirectory, Set<String> enabledChecks, boolean isPremium) throws IOException {
        CppcheckConfigurationBase configurationBase = isPremium ? new CppcheckPremiumConfiguration() : new CppcheckOpenSourceConfiguration();
        List<String> availableCheckIds = configurationBase.loadAvailableCheckIds();
        File configFile = new File(checkDirectory, CPPCHECK_SUPPRESS_CHECK_FILE);
        StringBuilder suppressBuilder = new StringBuilder();
        for (String availableCheckId : availableCheckIds) {
            if (enabledChecks.contains(availableCheckId)) continue;
            suppressBuilder.append(availableCheckId).append(StringUtils.LINE_SEPARATOR);
        }
        FileSystemUtils.writeFile((Path)configFile.toPath(), (String)suppressBuilder.toString(), (Charset)CHARSET);
    }

    private static List<IndexFinding> convertCppcheckResultsToFindings(File codeDir, BasicTokenElementInfo element, List<CppcheckResultItem> resultItems, boolean isPremium, Map<String, CheckMapping> selectedChecks, ListMap<String, RulesetInfo> guidelineRulesPerCheckId, LineOffsetConverterCache lineOffsetConverterCache) {
        if (resultItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexFinding> findings = new ArrayList<IndexFinding>();
        String uniformPath = element.getUniformPath();
        for (CppcheckResultItem resultItem : resultItems) {
            Optional<IndexFinding> finding;
            if (CppcheckRunner.handlePotentialErrorLog(resultItem, uniformPath) || !(finding = CppcheckRunner.tryGenerateFindingForCppCheckResultItem(element, isPremium, selectedChecks, guidelineRulesPerCheckId, resultItem, lineOffsetConverterCache, codeDir)).isPresent()) continue;
            findings.add(finding.get());
        }
        return findings;
    }

    private static Optional<IndexFinding> tryGenerateFindingForCppCheckResultItem(BasicTokenElementInfo element, boolean isPremium, Map<String, CheckMapping> selectedChecks, ListMap<String, RulesetInfo> guidelineRulesPerCheckId, CppcheckResultItem resultItem, LineOffsetConverterCache lineOffsetConverterCache, File codeDir) {
        if (resultItem.mainLocation() == null) {
            return Optional.empty();
        }
        Optional<String> findingLocationPath = CppcheckRunner.determineUniformPathFromCppcheckSourceFile(resultItem.mainLocation(), codeDir);
        if (findingLocationPath.isEmpty()) {
            return Optional.empty();
        }
        boolean crossFileAnalysisEnabled = EFeatureToggle.ENABLE_CLANG_TIDY_CPPCHECK_CROSS_FILE_ANALYSIS.isEnabled();
        if (!(!CppIntegratedToolUtils.isReanalyzeOnHeaderChangeAnalysisDisabled() && crossFileAnalysisEnabled || element.getUniformPath().equals(findingLocationPath.get()))) {
            return Optional.empty();
        }
        String checkId = CppcheckRunner.tryBuildCheckIdFromCppcheckErrorId(isPremium, resultItem.checkId());
        CheckMapping checkMapping = selectedChecks.get(checkId);
        if (checkMapping == null) {
            return Optional.empty();
        }
        Optional<LineOffsetConverter> lineOffsetConverter = lineOffsetConverterCache.getLineOffsetConverter(findingLocationPath.get());
        if (lineOffsetConverter.isEmpty()) {
            return Optional.empty();
        }
        @Nullable List guidelineRules = (List)guidelineRulesPerCheckId.getCollection((Object)checkId);
        IndexFinding finding = CppcheckRunner.createFinding(findingLocationPath.get(), resultItem, checkMapping, guidelineRules, lineOffsetConverter.get());
        CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
        finding.setCodeScopeName(codeScopeName);
        return Optional.of(finding);
    }

    private static IndexFinding createFinding(String findingLocationUniformPath, CppcheckResultItem resultItem, CheckMapping checkMapping, @Nullable List<RulesetInfo> guidelineRules, LineOffsetConverter lineOffsetConverter) {
        int line = resultItem.mainLocation().lineNumber();
        TextRegionLocation location = new TextRegionLocation(findingLocationUniformPath, lineOffsetConverter.getOffset(line), lineOffsetConverter.getOffset(line + 1) - 1, line, line);
        String message = CppcheckRunner.determineFindingMessage(resultItem, checkMapping);
        IndexFinding finding = new IndexFinding(checkMapping.checkId, CPPCHECK_EXECUTABLE_DEFAULT_NAME, message, (ElementLocation)location);
        StringBuilder cppcheckErrorInfoBuilder = new StringBuilder();
        for (Pair<CppcheckCodeLocation, String> item : resultItem.secondaryLocations()) {
            if (!resultItem.mainLocation().fullFilePath().equals(((CppcheckCodeLocation)item.getFirst()).fullFilePath())) continue;
            if (!cppcheckErrorInfoBuilder.isEmpty()) {
                cppcheckErrorInfoBuilder.append('\n');
            }
            cppcheckErrorInfoBuilder.append("Line ").append(((CppcheckCodeLocation)item.getFirst()).lineNumber()).append(": ").append((String)item.getSecond());
        }
        if (!cppcheckErrorInfoBuilder.isEmpty()) {
            finding.addProperties(Map.of("Cppcheck Error Info", cppcheckErrorInfoBuilder.toString()));
        }
        if (guidelineRules != null) {
            finding.setGuidelineMapping(CppcheckRunner.mapRuleDescriptionsByGuidelineName(guidelineRules));
        }
        return finding;
    }

    private static String determineFindingMessage(CppcheckResultItem resultItem, CheckMapping checkMapping) {
        if (resultItem.message().contains("(use --rule-texts=<file> to get proper output)")) {
            return checkMapping.getReadableCheckName();
        }
        String message = resultItem.message();
        if (CHECKS_WITH_UNECESSARY_WARNING.contains(checkMapping.checkId)) {
            message = message.replace(STANDARD_LIBRARY_HEADER_NOTE, "");
        }
        message = MarkupUtils.escapeMarkdownRelevantSymbols((String)message);
        message = StringUtils.truncateWithEllipsis((String)message, (int)1000);
        return message;
    }

    private static Optional<String> determineUniformPathFromCppcheckSourceFile(CppcheckCodeLocation resultItemMainLocation, File codeDir) {
        String absolutePathPrefix = codeDir.getAbsolutePath() + File.separator;
        String sourcePath = resultItemMainLocation.fullFilePath();
        if (!sourcePath.startsWith(absolutePathPrefix)) {
            return Optional.empty();
        }
        sourcePath = sourcePath.substring(absolutePathPrefix.length());
        return Optional.of(CppFileUtils.makeUnixPath(sourcePath));
    }

    private static boolean handlePotentialErrorLog(CppcheckResultItem resultItem, String uniformPath) {
        if (resultItem.checkId().equals("internalError")) {
            LOGGER.error("Cppcheck failed with an internal error for file {}: {}", (Object)uniformPath, (Object)resultItem.message());
            return true;
        }
        if (resultItem.checkId().equals("premium-invalidLicense")) {
            LOGGER.error("Tried to use cppcheck-premium, but cppcheck does not accept the current Teamscale license for the premium feature.");
            return true;
        }
        if (resultItem.checkId().equals("unmatchedSuppression")) {
            LOGGER.debug("Cppcheck unmatched suppression when running for file {}: {}", (Object)uniformPath, (Object)resultItem.message());
            return true;
        }
        return false;
    }

    private static @NonNull SetMap<String, String> mapRuleDescriptionsByGuidelineName(List<RulesetInfo> rules) {
        SetMap rulesByGuidelineId = new SetMap();
        for (RulesetInfo rule : rules) {
            rulesByGuidelineId.add((Object)rule.rulesetName, (Object)rule.getFullDescription());
        }
        return rulesByGuidelineId;
    }

    private static String tryBuildCheckIdFromCppcheckErrorId(boolean isPremium, String checkId) {
        if (!isPremium) {
            return checkId;
        }
        if (((String)checkId).startsWith("misra-c2023")) {
            checkId = ((String)checkId).replace("misra-c2023", "premium-misra-c-2023");
        }
        if (!((String)checkId).startsWith(CPPCHECK_PREMIUM_CHECKID_PREFIX)) {
            checkId = CPPCHECK_PREMIUM_CHECKID_PREFIX + (String)checkId;
        }
        return checkId;
    }

    public static boolean cppCheckIsAvailable() {
        String cppcheckExe = CppcheckRunner.loadConfiguredCppcheckExe();
        ProcessWrapper process = new ProcessWrapper(cppcheckExe);
        process.addArgument("--version");
        process.setOutputConsumer(t -> {});
        process.setErrorConsumer(t -> {});
        try {
            process.run(1L);
            return true;
        }
        catch (IOException | TimeoutException e) {
            return false;
        }
    }

    public static Pair<Integer, String> determineCppcheckVersion() {
        String cppcheckExe = CppcheckRunner.loadConfiguredCppcheckExe();
        ProcessWrapper process = new ProcessWrapper(cppcheckExe);
        process.addArgument("--version");
        StringBuffer combinedOut = new StringBuffer();
        process.setOutputConsumer(line -> combinedOut.append((String)line).append("\n"));
        process.setErrorConsumer(line -> combinedOut.append((String)line).append("\n"));
        int returnCode = process.runWithTimeout(1);
        return new Pair((Object)returnCode, (Object)combinedOut.toString());
    }

    public static Map<String, String> getCheckDescriptions() {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        String cppcheckExe = CppcheckRunner.loadConfiguredCppcheckExe();
        ProcessWrapper process = new ProcessWrapper(cppcheckExe);
        process.addArgument("--errorlist");
        StringBuilder stdOut = new StringBuilder();
        process.setOutputConsumer(line -> stdOut.append((String)line).append("\n"));
        process.setErrorConsumer(t -> {});
        process.runWithTimeout(1);
        try {
            Document parse = XMLUtils.parse((InputSource)new InputSource(new StringReader(CppcheckRunner.stripNonXmlPrefix(stdOut.toString()))));
            NodeList list = parse.getElementsByTagName("error");
            for (int temp = 0; temp < list.getLength(); ++temp) {
                Node node = list.item(temp);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String id = element.getAttribute("id");
                String description = element.getAttribute("verbose");
                description = CppcheckRunner.fixMarkdownFormatting(description);
                descriptions.put(id, description);
            }
        }
        catch (IOException | SAXException e) {
            LOGGER.error("Cannot parse output of 'cppcheck --errorlist': " + CppcheckRunner.getOutputSnippet(stdOut.toString()), (Throwable)e);
        }
        return descriptions;
    }

    private static String getOutputSnippet(String output) {
        return StringUtils.getFirstCharacters((String)output, (int)200);
    }

    @VisibleForTesting
    static String stripNonXmlPrefix(String output) throws IOException {
        int xmlTagIndex = output.indexOf("<?xml");
        if (xmlTagIndex == -1) {
            throw new IOException("Expected XML tag in output of CppCheck but got: " + CppcheckRunner.getOutputSnippet(output));
        }
        return output.substring(xmlTagIndex);
    }

    private static String fixMarkdownFormatting(String description) {
        return StringUtils.removeAll((String)description, (String[])new String[]{"''", "\"\"", "<>"}).replace("\\012", "<br>");
    }

    public static String loadConfiguredCppcheckExe() {
        String propertyValue = System.getProperty(CPPCHECK_EXE_VM_PROPERTY_NAME);
        if (propertyValue != null) {
            return propertyValue;
        }
        if (EFeatureToggle.CPPCHECK_PREMIUM_LICENSED.isEnabled() && Files.isExecutable(Path.of(CPPCHECK_PREMIUM_DOCKER_DEFAULT_LOCATION, new String[0]))) {
            return CPPCHECK_PREMIUM_DOCKER_DEFAULT_LOCATION;
        }
        return CPPCHECK_EXECUTABLE_DEFAULT_NAME;
    }

    private record CppcheckRunParameters(String jobId, BasicTokenElementInfo basicElement, String mainFilePath, boolean isConfigCheck, Map<String, CheckMapping> enabledCheckMappings, boolean isCppcheckPremium, boolean isDryRun, ListMap<String, RulesetInfo> guidelineRulesPerCheckId, File codeDirectory) {
    }

    public record CppcheckResultItem(CppcheckCodeLocation mainLocation, String message, String checkId, List<Pair<CppcheckCodeLocation, String>> secondaryLocations) {
    }

    public record CppcheckCodeLocation(String fullFilePath, int lineNumber, int column) {
    }
}

