/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.EMergeRequestUpdateTriggerSchedulingReason;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestProcessor;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.voting.PostponedVotingIndex;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class MergeRequestUpdateTriggerBase<PROVIDER extends MergeRequestProvider<PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB>, PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB>
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private MergeRequestIndex mergeRequestIndex;
    private BranchAnalysisStateIndex branchAnalysisStateIndex;
    private RepositoryRevisionIndex repositoryRevisionIndex;
    private CrossRepositoryMergeRequestSourceBranchesIndex crossRepositoryMergeRequestSourceBranchesIndex;
    private TriggerIndex triggerIndex;
    private PostponedVotingIndex postponedVotingIndex;

    public final void execute() throws ConQATException {
        MergeRequestIdentifier mergeRequestIdentifier = this.getMergeRequestIdentifierFromJobParameters();
        GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.jobDescriptor.getInternalProjectId());
        this.mergeRequestIndex = (MergeRequestIndex)projectStorageSystem.openProjectIndex(MergeRequestIndex.class, null);
        this.branchAnalysisStateIndex = (BranchAnalysisStateIndex)projectStorageSystem.openProjectIndex(BranchAnalysisStateIndex.class, null);
        this.repositoryRevisionIndex = (RepositoryRevisionIndex)projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null);
        this.triggerIndex = (TriggerIndex)projectStorageSystem.openProjectIndex(TriggerIndex.class, null);
        this.postponedVotingIndex = (PostponedVotingIndex)projectStorageSystem.openProjectIndex(PostponedVotingIndex.class, null);
        try {
            this.execute(mergeRequestIdentifier, this.createMergeRequestProvider(globalStorageSystem, (ProjectStorageSystem)projectStorageSystem, mergeRequestIdentifier.repositoryName()));
        }
        catch (ServiceCallException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void execute(MergeRequestIdentifier mergeRequestIdentifier, PROVIDER provider) throws StorageException, ServiceCallException {
        Object platformMergeRequest = ((MergeRequestProvider)provider).getPlatformMergeRequest(mergeRequestIdentifier.id());
        if (platformMergeRequest != null && ((MergeRequestProvider)provider).isCrossRepositoryMergeRequest(platformMergeRequest)) {
            this.openCrossRepositoryMergeRequestSourceBranchesIndex(mergeRequestIdentifier);
        }
        this.processMergeRequest(mergeRequestIdentifier, platformMergeRequest, provider);
    }

    protected void processMergeRequest(MergeRequestIdentifier mergeRequestIdentifier, @Nullable PLATFORM_SPECIFIC_MERGE_REQUEST platformSpecificMergeRequest, PROVIDER provider) throws StorageException, ServiceCallException {
        Optional<MergeRequest> oldMergeRequest = this.fetchMergeRequestFromIndex(mergeRequestIdentifier);
        MergeRequestProcessor.ProcessMergeRequestResult processMergeRequestResult = new MergeRequestProcessor<PROVIDER, PLATFORM_SPECIFIC_MERGE_REQUEST>(provider, this.mergeRequestIndex, this.crossRepositoryMergeRequestSourceBranchesIndex, this.postponedVotingIndex).processMergeRequest(mergeRequestIdentifier, platformSpecificMergeRequest);
        MergeRequest updatedMergeRequest = processMergeRequestResult.updatedMergeRequest();
        if (updatedMergeRequest == null || updatedMergeRequest.status != EMergeRequestStatus.OPEN) {
            LOGGER.debug("Merge request {} was not updated or is not open anymore, skipping scheduling of annotation trigger.", (Object)mergeRequestIdentifier);
            return;
        }
        CrossRepositoryMergeRequestSourceBranch crossRepositoryMergeRequestSourceBranch = processMergeRequestResult.crossRepositorySourceBranch();
        Optional<CommitDescriptor> headCommit = MergeRequestUtils.retrieveMergeRequestHeadCommitIfLive(updatedMergeRequest, this.repositoryRevisionIndex, this.branchAnalysisStateIndex, crossRepositoryMergeRequestSourceBranch);
        if (headCommit.isEmpty()) {
            if (processMergeRequestResult.crossRepositorySourceBranchWasUpdated()) {
                LOGGER.debug("Handling cross-repository merge request. Scheduling additional triggers.");
                RepositoryUpdateUtils.extractAndScheduleAffectedTriggers(mergeRequestIdentifier.repositoryName(), this.indexLayer);
            }
            LOGGER.debug("Analysis did not reach live analysis, skipping scheduling of annotation trigger.");
            this.evaluateAndRecordPostponedVote(updatedMergeRequest.identifier, processMergeRequestResult.mergeRequestNeedsUpdate());
            return;
        }
        this.schedulePostBuildCompletenessTriggers(((MergeRequestProvider)provider).requiresBuildCompletenessBeforeVoting(), oldMergeRequest.orElse(null), updatedMergeRequest);
        this.scheduleMergeRequestAnnotationTrigger(updatedMergeRequest, this.determineSchedulingCommit(headCommit.get()), processMergeRequestResult.mergeRequestNeedsUpdate());
    }

    private void evaluateAndRecordPostponedVote(MergeRequestIdentifier identifier, boolean mergeRequestNeedsUpdate) throws StorageException {
        EMergeRequestUpdateTriggerSchedulingReason schedulingReason = EMergeRequestUpdateTriggerSchedulingReason.fromString(this.jobDescriptor.getSchedulingReason());
        if (schedulingReason == EMergeRequestUpdateTriggerSchedulingReason.FORCE_VOTE || schedulingReason == EMergeRequestUpdateTriggerSchedulingReason.WEBHOOK_RECEIVED && mergeRequestNeedsUpdate) {
            this.postponedVotingIndex.addPostponedVote(identifier);
            LOGGER.debug("Recorded postponed vote for merge request '{}'. Reason: {}", (Object)identifier.toString(), (Object)schedulingReason);
        } else {
            LOGGER.debug("Did not record a postponed vote for merge request '{}'. Scheduling reason: '{}'. Merge request needs an update: '{}'", (Object)identifier.toString(), (Object)schedulingReason, (Object)mergeRequestNeedsUpdate);
        }
    }

    private CommitDescriptor determineSchedulingCommit(CommitDescriptor mergeRequestHeadCommit) {
        if (this.jobDescriptor.getSchedulingCommit() != null) {
            return this.jobDescriptor.getSchedulingCommit();
        }
        return mergeRequestHeadCommit;
    }

    private Optional<MergeRequest> fetchMergeRequestFromIndex(MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        Optional<MergeRequest> storedMergeRequest = this.mergeRequestIndex.getMergeRequest(mergeRequestIdentifier);
        storedMergeRequest.ifPresentOrElse(mr -> LOGGER.debug("Fetched merge request {} from the index: {}", new Supplier[]{() -> mergeRequestIdentifier, () -> JsonUtils.serializeToJSON((Object)mr)}), () -> LOGGER.debug("Merge request {} was not found in the index", (Object)mergeRequestIdentifier));
        return storedMergeRequest;
    }

    private void schedulePostBuildCompletenessTriggers(boolean isBuildCompletenessRequired, MergeRequest storedMergeRequest, MergeRequest currentMergeRequest) throws StorageException {
        if (!isBuildCompletenessRequired) {
            LOGGER.debug("Build completeness is not required before voting, skipping scheduling of post build triggers.");
            return;
        }
        if (storedMergeRequest != null && storedMergeRequest.buildPipelineInfo.isBuildComplete()) {
            LOGGER.debug("Pipelines were already completed before. Assuming that we already processed the merge request and skipping scheduling of post build triggers.");
            return;
        }
        if (currentMergeRequest.buildPipelineInfo.isBuildComplete()) {
            for (String triggerName : this.triggerIndex.getPostBuildCompletenessAnalysisTriggers()) {
                ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.indexLayer, this.jobDescriptor.getInternalProjectId(), triggerName);
            }
        }
    }

    private void openCrossRepositoryMergeRequestSourceBranchesIndex(MergeRequestIdentifier mergeRequestIdentifier) throws ServiceCallException, StorageException {
        String connectorIdentifier = MergeRequestUtils.guessConnectorFromProject(this.indexLayer, (IProjectId)this.jobDescriptor.getInternalProjectId(), mergeRequestIdentifier.repositoryName()).map(ConnectorConfiguration::getIdentifier).orElseThrow(() -> new StorageException("Failed to find matching connector for merge request '" + String.valueOf(mergeRequestIdentifier) + "'."));
        if (connectorIdentifier == null) {
            throw new ServiceCallException("Failed to open cross-repository merge request indexes for merge request '" + String.valueOf(mergeRequestIdentifier) + "'.");
        }
        this.crossRepositoryMergeRequestSourceBranchesIndex = (CrossRepositoryMergeRequestSourceBranchesIndex)this.indexLayer.openProjectIndex((IProjectId)this.jobDescriptor.getInternalProjectId(), CrossRepositoryMergeRequestSourceBranchesIndex.class, CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName(connectorIdentifier), null);
    }

    protected abstract PROVIDER createMergeRequestProvider(GlobalStorageSystem var1, ProjectStorageSystem var2, String var3) throws StorageException, ServiceCallException;

    protected abstract MergeRequestAnnotationTriggerBase<PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB> createMergeRequestAnnotationTrigger();

    private void scheduleMergeRequestAnnotationTrigger(MergeRequest mergeRequest, CommitDescriptor headCommit, boolean mergeRequestNeedsNewVote) throws StorageException {
        boolean forceMergeRequestVote = this.getMergeRequestForceVoteFlagFromJobParameters();
        VotingRecordIndex votingRecordIndex = (VotingRecordIndex)this.indexLayer.openProjectIndex((IProjectId)this.jobDescriptor.getInternalProjectId(), VotingRecordIndex.class, null);
        Optional<VotingRecord> votingRecord = votingRecordIndex.getVotingRecord(headCommit);
        if (votingRecord.isEmpty() && !forceMergeRequestVote) {
            LOGGER.debug("Post revision triggers for {} did not run yet and no vote was forced, so we wait for analysis to finish instead of scheduling a vote here.", (Object)headCommit);
            return;
        }
        if (mergeRequest.status == EMergeRequestStatus.MERGED) {
            LOGGER.info("Skipping scheduling of merge request annotation trigger, as the merge request was merged.");
            return;
        }
        MergeRequestAnnotationTriggerBase<PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB> annotationTrigger = this.createMergeRequestAnnotationTrigger();
        annotationTrigger.init(new JobDescriptor(this.jobDescriptor.getInternalProjectId(), ((Object)annotationTrigger).getClass(), headCommit, (Object)Boolean.toString(mergeRequestNeedsNewVote || forceMergeRequestVote), "Scheduling annotation trigger from update trigger for merge request " + String.valueOf(mergeRequest.identifier) + ": " + this.jobDescriptor.getSchedulingReason()), this.indexLayer, this.lockProvider, this.instanceConfiguration, this.getContext());
        LOGGER.debug("Executing annotation trigger for merge request {} with commit {}.", (Object)mergeRequest.identifier, (Object)headCommit);
        annotationTrigger.execute();
    }

    private MergeRequestIdentifier getMergeRequestIdentifierFromJobParameters() throws JsonSerializationException {
        return ((JobParameter)this.jobDescriptor.getParameterObject(JobParameter.class)).identifier();
    }

    @VisibleForTesting
    public final String getJobExtraParameter() {
        try {
            return ((JobParameter)this.jobDescriptor.getParameterObject(JobParameter.class)).extraParam();
        }
        catch (JsonSerializationException e) {
            return null;
        }
    }

    private boolean getMergeRequestForceVoteFlagFromJobParameters() {
        try {
            return ((JobParameter)this.jobDescriptor.getParameterObject(JobParameter.class)).forceVote();
        }
        catch (JsonSerializationException e) {
            return false;
        }
    }

    protected static ConnectorConfiguration extractConnectorConfiguration(ProjectStorageSystem projectStorageSystem, String repositoryName, ERepositoryConnector connector) throws StorageException {
        MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        List connectors = ((ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class)).getConnectorsByType((IConnectorEnum)connector);
        Optional<ConnectorConfiguration> configuration = connectors.stream().filter(connectorConfiguration -> repositoryName.equalsIgnoreCase(connectorConfiguration.getOptionValue("Repository name"))).findAny();
        if (configuration.isEmpty()) {
            throw new StorageException("Failed to extract " + connector.getReadableName() + " connector for repository " + repositoryName + ". Tried to find '" + repositoryName + "', but only found " + connectors.stream().map(connectorConfiguration -> connectorConfiguration.getOptionValue("Repository name")).collect(Collectors.joining("', '", "'", "'")));
        }
        return configuration.get();
    }

    protected ExternalCredentials extractCredentials(GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem, String repositoryName, ERepositoryConnector connector) throws StorageException {
        ConnectorConfiguration configuration = MergeRequestUpdateTriggerBase.extractConnectorConfiguration(projectStorageSystem, repositoryName, connector);
        return MergeRequestUpdateTriggerBase.extractCredentials(configuration, globalStorageSystem);
    }

    public static ExternalCredentials extractCredentials(ConnectorConfiguration connectorConfiguration, GlobalStorageSystem globalStorageSystem) throws StorageException {
        String account = connectorConfiguration.getOptionValue("Account");
        if (account == null) {
            throw new StorageException("Failed to extract account for connector with id " + connectorConfiguration.getIdentifier());
        }
        ExternalCredentialsIndex credentialsIndex = (ExternalCredentialsIndex)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials credentials = credentialsIndex.getExternalCredentials(account);
        if (credentials == null) {
            throw new StorageException("Failed to find credentials for account " + account);
        }
        return credentials;
    }

    public record JobParameter(MergeRequestIdentifier identifier, boolean forceVote, @Nullable String extraParam) {
    }
}

