/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Collections;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion32PolarionConnectorStartTimestampMigration {
    private static final String NEW_START_TIMESTAMP_NAME = "Start Timestamp";
    private static final String OLD_START_TIMESTAMP_NAME = "History Start Timestamp";

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion32PolarionConnectorStartTimestampMigration::migratePolarionStartTimestamp);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migratePolarionStartTimestamp(ConnectorConfiguration connectorConfiguration) {
        String changedSince;
        if (ERequirementsManagementTool.POLARION.getReadableName().equals(connectorConfiguration.getRawType()) && (changedSince = connectorConfiguration.getOptionValue(OLD_START_TIMESTAMP_NAME)) != null) {
            connectorConfiguration.removeOptions(Collections.singleton(OLD_START_TIMESTAMP_NAME));
            connectorConfiguration.setOptionValue(NEW_START_TIMESTAMP_NAME, changedSince);
        }
        return connectorConfiguration;
    }
}

