/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion49RenameBitbucketServerToDataCenter {
    private static final String OLD_CONNECTOR_TYPE = "Bitbucket Server (On-Premise)";
    private static final String NEW_CONNECTOR_TYPE = "Bitbucket Data Center (On-Premise)";

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion49RenameBitbucketServerToDataCenter::renameBitbucketConnectorType);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration renameBitbucketConnectorType(ConnectorConfiguration connectorConfiguration) {
        if (!OLD_CONNECTOR_TYPE.equals(connectorConfiguration.getRawType())) {
            return connectorConfiguration;
        }
        ConnectorConfiguration migratedConfig = new ConnectorConfiguration(NEW_CONNECTOR_TYPE, "Repository identifier");
        for (Map.Entry option : Objects.requireNonNull(connectorConfiguration.getOptions()).entrySet()) {
            migratedConfig.setOptionValue((String)option.getKey(), (String)option.getValue());
        }
        return migratedConfig;
    }
}

