/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser.fortify;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.parser.fortify.FortifyIssueData;
import com.teamscale.index.upload.IExternalToolRule;
import com.teamscale.index.upload.fortify.FortifyRule;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class FortifyReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FORTIFY_CATEGORY = "Fortify";
    private Map<String, IExternalToolRule> rulesById;

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        if (StringUtils.isEmpty((String)report)) {
            LOGGER.info("Empty Fortify report \"{}\"", (Object)reportPath);
            return;
        }
        try {
            this.rulesById = new HashMap<String, IExternalToolRule>();
            this.parseJsonReport(report);
        }
        catch (IOException e) {
            throw new ReportParserException("Error parsing Fortify report", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            throw new ReportParserException("Out of memory parsing large Fortify report. Consider increasing heap size or splitting the report.", (Throwable)e);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        FortifyReportParser.checkEnabledAnalysisTool(EAnalysisTool.FORTIFY, analysisProfiles, projectId);
    }

    @Override
    public Collection<IExternalToolRule> getRules() {
        return this.rulesById.values();
    }

    @Override
    public EAnalysisTool getAnalysisTool() {
        return EAnalysisTool.FORTIFY;
    }

    private void parseJsonReport(String report) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        try (JsonParser parser = objectMapper.createParser(report);){
            this.parseJsonStream(parser);
        }
        catch (StorageException e) {
            throw new IOException("Storage error during JSON parsing", e);
        }
    }

    private void parseJsonStream(JsonParser parser) throws IOException, StorageException {
        if (parser.nextToken() != JsonToken.START_ARRAY) {
            throw new IOException("Expected JSON array at root level");
        }
        while (parser.nextToken() == JsonToken.START_OBJECT) {
            this.processIssueObject(parser);
        }
    }

    private void processIssueObject(JsonParser parser) throws IOException, StorageException {
        FortifyIssueData issueData = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (fieldName.equals("data")) {
                issueData = (FortifyIssueData)parser.readValueAs(FortifyIssueData.class);
                continue;
            }
            parser.skipChildren();
        }
        if (FortifyReportParser.shouldProcessIssue(issueData)) {
            this.createFindingFromIssueData(issueData);
        }
    }

    private static boolean shouldProcessIssue(@Nullable FortifyIssueData data) {
        return data != null && !StringUtils.isEmpty((String)data.fullFileName()) && data.lineNumber() > 0 && !StringUtils.isEmpty((String)data.issueName());
    }

    private void createFindingFromIssueData(FortifyIssueData data) throws StorageException {
        Optional<String> uniformPath = this.resolvePath(data.fullFileName());
        if (uniformPath.isEmpty()) {
            return;
        }
        FortifyRule rule = this.getOrCreateRule(data);
        TextRegionLocation location = FortifyReportParser.createLineLocation(uniformPath.get(), data.lineNumber(), data.lineNumber());
        DetachedFinding finding = FortifyReportParser.createFindingWithLocation(rule.getId(), rule.getId(), FORTIFY_CATEGORY, data.issueName(), (ElementLocation)location);
        if (!StringUtils.isEmpty((String)data.detail())) {
            finding.setProperty("Detail [important]", (Object)data.detail());
        }
        finding.setProperty("Severity", (Object)data.severity());
        finding.setProperty("Impact", (Object)data.impact());
        finding.setProperty("Likelihood", (Object)data.likelihood());
        finding.setProperty("Confidence", (Object)data.confidence());
        finding.setProperty("Friority", (Object)data.friority());
        finding.setProperty("IssueInstanceId", (Object)data.issueInstanceId());
        finding.setProperty("ProjectVersionId", (Object)data.projectVersionId());
        this.addFindingForPath(uniformPath.get(), finding);
        boolean isFalsePositive = "Not an Issue".equals(data.issueState());
        finding.setProperty("Marked as False Positive externally", (Object)isFalsePositive);
        finding.setProperty("Tolerated Externally", (Object)false);
    }

    private FortifyRule getOrCreateRule(FortifyIssueData data) {
        String ruleId = data.issueName();
        return (FortifyRule)this.rulesById.computeIfAbsent(ruleId, id -> new FortifyRule(data));
    }
}

